/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.commons.compiler.jdk;

import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.Cookable;
import org.codehaus.commons.compiler.ISimpleCompiler;
import org.codehaus.commons.compiler.Location;
import org.codehaus.commons.compiler.jdk.ByteArrayJavaFileManager;
import org.codehaus.commons.compiler.jdk.JavaFileManagerClassLoader;

public class SimpleCompiler
extends Cookable
implements ISimpleCompiler {
    private ClassLoader parentClassLoader = Thread.currentThread().getContextClassLoader();
    private ClassLoader result;
    private boolean debugSource;
    private boolean debugLines;
    private boolean debugVars;

    public ClassLoader getClassLoader() {
        this.assertCooked();
        return this.result;
    }

    public void cook(String optionalFileName, final Reader r) throws CompileException, IOException {
        URI uri;
        this.assertNotCooked();
        try {
            uri = new URI("simplecompiler");
        }
        catch (URISyntaxException use) {
            throw new RuntimeException(use);
        }
        SimpleJavaFileObject compilationUnit = new SimpleJavaFileObject(uri, JavaFileObject.Kind.SOURCE){

            @Override
            public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
                return true;
            }

            @Override
            public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
                return r;
            }

            @Override
            public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
                return Cookable.readString((Reader)this.openReader(ignoreEncodingErrors));
            }
        };
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (compiler == null) {
            throw new CompileException("JDK Java compiler not available - probably you're running a JRE, not a JDK", null);
        }
        StandardJavaFileManager fm = compiler.getStandardFileManager(null, null, null);
        final ByteArrayJavaFileManager<StandardJavaFileManager> fileManager = new ByteArrayJavaFileManager<StandardJavaFileManager>(fm);
        try {
            if (!compiler.getTask(null, fileManager, (DiagnosticListener<? super JavaFileObject>)new DiagnosticListener<JavaFileObject>(){

                @Override
                public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
                    Location loc = new Location(diagnostic.getSource().toString(), (short)diagnostic.getLineNumber(), (short)diagnostic.getColumnNumber());
                    String code = diagnostic.getCode();
                    String message = diagnostic.getMessage(null) + " (" + code + ")";
                    throw new RuntimeException((Throwable)new CompileException(message, loc));
                }
            }, Collections.singletonList(this.debugSource ? "-g:source" + (this.debugLines ? ",lines" : "") + (this.debugVars ? ",vars" : "") : (this.debugLines ? "-g:lines" + (this.debugVars ? ",vars" : "") : (this.debugVars ? "-g:vars" : "-g:none"))), null, Collections.singleton(compilationUnit)).call().booleanValue()) {
                throw new CompileException("Compilation failed", null);
            }
        }
        catch (RuntimeException rte) {
            Throwable cause = rte.getCause();
            if (cause != null) {
                if ((cause = cause.getCause()) instanceof CompileException) {
                    throw (CompileException)cause;
                }
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
            }
            throw rte;
        }
        this.result = AccessController.doPrivileged(new PrivilegedAction<JavaFileManagerClassLoader>(){

            @Override
            public JavaFileManagerClassLoader run() {
                return new JavaFileManagerClassLoader(fileManager, SimpleCompiler.this.parentClassLoader);
            }
        });
    }

    protected void cook(JavaFileObject compilationUnit) throws CompileException, IOException {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (compiler == null) {
            throw new CompileException("JDK Java compiler not available - probably you're running a JRE, not a JDK", null);
        }
        StandardJavaFileManager fm = compiler.getStandardFileManager(null, null, null);
        final ByteArrayJavaFileManager<StandardJavaFileManager> fileManager = new ByteArrayJavaFileManager<StandardJavaFileManager>(fm);
        try {
            if (!compiler.getTask(null, fileManager, (DiagnosticListener<? super JavaFileObject>)new DiagnosticListener<JavaFileObject>(){

                @Override
                public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
                    System.err.println("*** " + diagnostic.toString() + " *** " + diagnostic.getCode());
                    Location loc = new Location(diagnostic.getSource().toString(), (short)diagnostic.getLineNumber(), (short)diagnostic.getColumnNumber());
                    String code = diagnostic.getCode();
                    String message = diagnostic.getMessage(null) + " (" + code + ")";
                    throw new RuntimeException((Throwable)new CompileException(message, loc));
                }
            }, null, null, Collections.singleton(compilationUnit)).call().booleanValue()) {
                throw new CompileException("Compilation failed", null);
            }
        }
        catch (RuntimeException rte) {
            Throwable cause = rte.getCause();
            if (cause != null) {
                if ((cause = cause.getCause()) instanceof CompileException) {
                    throw (CompileException)cause;
                }
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
            }
            throw rte;
        }
        this.result = AccessController.doPrivileged(new PrivilegedAction<JavaFileManagerClassLoader>(){

            @Override
            public JavaFileManagerClassLoader run() {
                return new JavaFileManagerClassLoader(fileManager, SimpleCompiler.this.parentClassLoader);
            }
        });
    }

    public void setDebuggingInformation(boolean debugSource, boolean debugLines, boolean debugVars) {
        this.debugSource = debugSource;
        this.debugLines = debugLines;
        this.debugVars = debugVars;
    }

    public void setParentClassLoader(ClassLoader optionalParentClassLoader) {
        this.assertNotCooked();
        this.parentClassLoader = optionalParentClassLoader != null ? optionalParentClassLoader : Thread.currentThread().getContextClassLoader();
    }

    @Deprecated
    public void setParentClassLoader(ClassLoader optionalParentClassLoader, Class<?>[] auxiliaryClasses) {
        this.setParentClassLoader(optionalParentClassLoader);
    }

    protected void assertCooked() {
        if (this.result == null) {
            throw new IllegalStateException("Not yet cooked");
        }
    }

    protected void assertNotCooked() {
        if (this.result != null) {
            throw new IllegalStateException("Already cooked");
        }
    }
}

