/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.deser;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.DeserializerProvider;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.KeyDeserializer;
import org.codehaus.jackson.map.ResolvableDeserializer;
import org.codehaus.jackson.map.deser.Creator;
import org.codehaus.jackson.map.deser.CreatorContainer;
import org.codehaus.jackson.map.deser.PropertyValueBuffer;
import org.codehaus.jackson.map.deser.SettableBeanProperty;
import org.codehaus.jackson.map.deser.StdDeserializer;
import org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapDeserializer
extends StdDeserializer<Map<Object, Object>>
implements ResolvableDeserializer {
    final JavaType _mapType;
    final KeyDeserializer _keyDeserializer;
    final JsonDeserializer<Object> _valueDeserializer;
    final Constructor<Map<Object, Object>> _defaultCtor;
    protected Creator.PropertyBased _propertyBasedCreator;

    public MapDeserializer(JavaType mapType, Constructor<Map<Object, Object>> defCtor, KeyDeserializer keyDeser, JsonDeserializer<Object> valueDeser) {
        super(Map.class);
        this._mapType = mapType;
        this._defaultCtor = defCtor;
        this._keyDeserializer = keyDeser;
        this._valueDeserializer = valueDeser;
    }

    public void setCreators(CreatorContainer creators) {
        this._propertyBasedCreator = creators.propertyBasedCreator();
    }

    public void validateCreators() throws JsonMappingException {
        if (this._defaultCtor == null && this._propertyBasedCreator == null) {
            throw new JsonMappingException("Can not create deserializer for Map type " + this.getMapClass().getName() + ": no default/delegating constructor or factory methods found");
        }
    }

    @Override
    public void resolve(DeserializationConfig config, DeserializerProvider provider) throws JsonMappingException {
        if (this._propertyBasedCreator != null) {
            HashMap<JavaType, JsonDeserializer<Object>> seen = new HashMap<JavaType, JsonDeserializer<Object>>();
            for (SettableBeanProperty prop : this._propertyBasedCreator.properties()) {
                prop.setValueDeserializer(this.findDeserializer(config, provider, prop.getType(), prop.getPropertyName(), seen));
            }
        }
    }

    @Override
    public Map<Object, Object> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Map<Object, Object> result;
        if (jp.getCurrentToken() != JsonToken.START_OBJECT) {
            throw ctxt.mappingException(this.getMapClass());
        }
        if (this._propertyBasedCreator != null) {
            return this._deserializeUsingCreator(jp, ctxt);
        }
        try {
            result = this._defaultCtor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw ctxt.instantiationException(this.getMapClass(), e);
        }
        this._readAndBind(jp, ctxt, result);
        return result;
    }

    @Override
    public Map<Object, Object> deserialize(JsonParser jp, DeserializationContext ctxt, Map<Object, Object> result) throws IOException, JsonProcessingException {
        if (jp.getCurrentToken() != JsonToken.START_OBJECT) {
            throw ctxt.mappingException(this.getMapClass());
        }
        this._readAndBind(jp, ctxt, result);
        return result;
    }

    public final Class<?> getMapClass() {
        return this._mapType.getRawClass();
    }

    @Override
    public JavaType getValueType() {
        return this._mapType;
    }

    protected final void _readAndBind(JsonParser jp, DeserializationContext ctxt, Map<Object, Object> result) throws IOException, JsonProcessingException {
        KeyDeserializer keyDes = this._keyDeserializer;
        JsonDeserializer<Object> valueDes = this._valueDeserializer;
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String fieldName = jp.getCurrentName();
            String key = keyDes == null ? fieldName : keyDes.deserializeKey(fieldName, ctxt);
            JsonToken t = jp.nextToken();
            Object value = t == JsonToken.VALUE_NULL ? null : valueDes.deserialize(jp, ctxt);
            result.put(key, value);
        }
    }

    public Map<Object, Object> _deserializeUsingCreator(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Creator.PropertyBased creator = this._propertyBasedCreator;
        PropertyValueBuffer buffer = creator.startBuilding(jp, ctxt);
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String propName = jp.getCurrentName();
            SettableBeanProperty prop = creator.findCreatorProperty(propName);
            if (prop != null) {
                if (!buffer.assignParameter(prop.getCreatorIndex(), prop.deserialize(jp, ctxt))) continue;
                Map result = (Map)creator.build(buffer);
                this._readAndBind(jp, ctxt, result);
                return result;
            }
            String fieldName = jp.getCurrentName();
            String key = this._keyDeserializer == null ? fieldName : this._keyDeserializer.deserializeKey(fieldName, ctxt);
            JsonToken t = jp.nextToken();
            Object value = t == JsonToken.VALUE_NULL ? null : this._valueDeserializer.deserialize(jp, ctxt);
            buffer.bufferMapProperty(key, value);
        }
        return (Map)creator.build(buffer);
    }
}

