/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.deser;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.deser.FromStringDeserializer;

public class CoreXMLDeserializers {
    static final DatatypeFactory _dataTypeFactory;

    static {
        try {
            _dataTypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class QNameDeserializer
    extends FromStringDeserializer<QName> {
        public QNameDeserializer() {
            super(QName.class);
        }

        @Override
        protected QName _deserialize(String value, DeserializationContext ctxt) throws IllegalArgumentException {
            return QName.valueOf(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GregorianCalendarDeserializer
    extends FromStringDeserializer<XMLGregorianCalendar> {
        public GregorianCalendarDeserializer() {
            super(XMLGregorianCalendar.class);
        }

        @Override
        protected XMLGregorianCalendar _deserialize(String value, DeserializationContext ctxt) throws IllegalArgumentException {
            return _dataTypeFactory.newXMLGregorianCalendar(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DurationDeserializer
    extends FromStringDeserializer<Duration> {
        public DurationDeserializer() {
            super(Duration.class);
        }

        @Override
        protected Duration _deserialize(String value, DeserializationContext ctxt) throws IllegalArgumentException {
            return _dataTypeFactory.newDuration(value);
        }
    }
}

