/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.introspect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.codehaus.jackson.map.introspect.Annotated;
import org.codehaus.jackson.map.introspect.AnnotatedParameter;
import org.codehaus.jackson.map.introspect.AnnotationMap;
import org.codehaus.jackson.map.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotatedMethod
extends Annotated {
    final Method _method;
    final AnnotationMap _annotations;
    final AnnotationMap[] _paramAnnotations;
    public Class<?>[] _paramTypes;

    public AnnotatedMethod(Method method, AnnotationMap annMap, AnnotationMap[] paramAnnotations) {
        this._method = method;
        this._annotations = annMap;
        this._paramAnnotations = paramAnnotations;
    }

    public void addIfNotPresent(Annotation a) {
        this._annotations.addIfNotPresent(a);
    }

    public void addOrOverride(Annotation a) {
        this._annotations.add(a);
    }

    public void addOrOverrideParam(int paramIndex, Annotation a) {
        AnnotationMap old = this._paramAnnotations[paramIndex];
        if (old == null) {
            this._paramAnnotations[paramIndex] = old = new AnnotationMap();
        }
        old.add(a);
    }

    @Override
    public Method getAnnotated() {
        return this._method;
    }

    @Override
    public int getModifiers() {
        return this._method.getModifiers();
    }

    @Override
    public String getName() {
        return this._method.getName();
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> acls) {
        return this._annotations.get(acls);
    }

    @Override
    public Class<?> getType() {
        return this.getReturnType();
    }

    public AnnotatedParameter getParameter(int index) {
        return new AnnotatedParameter(this.getParameterType(index), this._paramAnnotations[index]);
    }

    public Type[] getParameterTypes() {
        return this._method.getGenericParameterTypes();
    }

    public Class<?>[] getParameterClasses() {
        if (this._paramTypes == null) {
            this._paramTypes = this._method.getParameterTypes();
        }
        return this._paramTypes;
    }

    public int getParameterCount() {
        return this.getParameterTypes().length;
    }

    public Class<?> getParameterClass(int index) {
        Class<?>[] types = this._method.getParameterTypes();
        return index >= types.length ? null : types[index];
    }

    public Type getParameterType(int index) {
        Type[] types = this._method.getGenericParameterTypes();
        return index >= types.length ? null : types[index];
    }

    public AnnotationMap getParameterAnnotations(int index) {
        if (this._paramAnnotations != null && index >= 0 && index <= this._paramAnnotations.length) {
            return this._paramAnnotations[index];
        }
        return null;
    }

    public Type getGenericReturnType() {
        return this._method.getGenericReturnType();
    }

    public Class<?> getReturnType() {
        return this._method.getReturnType();
    }

    public Class<?> getDeclaringClass() {
        return this._method.getDeclaringClass();
    }

    public String getFullName() {
        return this.getDeclaringClass().getName() + "#" + this.getName() + "(" + this.getParameterCount() + " params)";
    }

    public int getAnnotationCount() {
        return this._annotations.size();
    }

    public void fixAccess() {
        ClassUtil.checkAndFixAccess(this._method);
    }

    public String toString() {
        return "[method " + this.getName() + ", annotations: " + this._annotations + "]";
    }
}

