/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.deser;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.DeserializerProvider;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ResolvableDeserializer;
import org.codehaus.jackson.map.annotate.JsonCachable;
import org.codehaus.jackson.map.deser.SettableAnyProperty;
import org.codehaus.jackson.map.deser.SettableBeanProperty;
import org.codehaus.jackson.map.deser.StdDeserializer;
import org.codehaus.jackson.map.introspect.AnnotatedConstructor;
import org.codehaus.jackson.map.introspect.AnnotatedMethod;
import org.codehaus.jackson.map.type.TypeFactory;
import org.codehaus.jackson.map.util.ClassUtil;
import org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JsonCachable
public class BeanDeserializer
extends StdDeserializer<Object>
implements ResolvableDeserializer {
    protected final JavaType _beanType;
    protected Constructor<?> _defaultConstructor;
    protected StringCreator _stringCreator;
    protected NumberCreator _numberCreator;
    protected DelegatingCreator _delegatingCreator;
    protected PropertyBasedCreator _propertyBasedCreator;
    protected final HashMap<String, SettableBeanProperty> _props;
    protected SettableAnyProperty _anySetter;
    protected HashSet<String> _ignorableProps;

    public BeanDeserializer(JavaType type) {
        super(type.getRawClass());
        this._beanType = type;
        this._props = new HashMap();
        this._ignorableProps = null;
    }

    public void setDefaultConstructor(Constructor<?> ctor) {
        this._defaultConstructor = ctor;
    }

    public void setCreators(CreatorContainer creators) {
        this._stringCreator = creators.stringCreator();
        this._numberCreator = creators.numberCreator();
        this._delegatingCreator = creators.delegatingCreator();
        this._propertyBasedCreator = creators.propertyBasedCreator();
        if (this._delegatingCreator != null || this._propertyBasedCreator != null) {
            this._defaultConstructor = null;
        }
    }

    public void addProperty(SettableBeanProperty prop) {
        SettableBeanProperty old = this._props.put(prop.getPropertyName(), prop);
        if (old != null && old != prop) {
            throw new IllegalArgumentException("Duplicate property '" + prop.getPropertyName() + "' for " + this._beanType);
        }
    }

    public SettableBeanProperty removeProperty(String name) {
        return this._props.remove(name);
    }

    public void setAnySetter(SettableAnyProperty s) {
        if (this._anySetter != null && s != null) {
            throw new IllegalStateException("_anySetter already set to non-null");
        }
        this._anySetter = s;
    }

    public void addIgnorable(String propName) {
        if (this._ignorableProps == null) {
            this._ignorableProps = new HashSet();
        }
        this._ignorableProps.add(propName);
    }

    public void validateCreators() throws JsonMappingException {
        if (this._defaultConstructor == null && this._numberCreator == null && this._stringCreator == null && this._delegatingCreator == null && this._propertyBasedCreator == null) {
            throw new JsonMappingException("Can not create Bean deserializer for (" + this._beanType + "): neither default/delegating constructor nor factory methods found");
        }
    }

    @Override
    public void resolve(DeserializationConfig config, DeserializerProvider provider) throws JsonMappingException {
        JsonDeserializer<Object> deser;
        JavaType type;
        HashMap seen = null;
        for (SettableBeanProperty prop : this._props.values()) {
            if (prop.hasValueDeserializer()) continue;
            type = prop.getType();
            deser = null;
            if (seen != null) {
                deser = (JsonDeserializer<Object>)seen.get(type);
            }
            if (deser == null) {
                deser = this.findDeserializer(config, provider, type, prop.getPropertyName(), seen);
            }
            prop.setValueDeserializer(deser);
        }
        if (this._anySetter != null && !this._anySetter.hasValueDeserializer()) {
            JavaType type2 = this._anySetter.getType();
            JsonDeserializer<Object> deser2 = null;
            if (seen != null) {
                deser2 = (JsonDeserializer<Object>)seen.get(type2);
            }
            if (deser2 == null) {
                deser2 = this.findDeserializer(config, provider, type2, "[any]", seen);
            }
            this._anySetter.setValueDeserializer(deser2);
        }
        if (this._delegatingCreator != null) {
            JsonDeserializer<Object> deser3 = this.findDeserializer(config, provider, this._delegatingCreator.getValueType(), "[constructor-arg[0]]", seen);
            this._delegatingCreator.setDeserializer(deser3);
        }
        if (this._propertyBasedCreator != null) {
            for (SettableBeanProperty prop : this._propertyBasedCreator.properties()) {
                type = prop.getType();
                deser = null;
                if (seen != null) {
                    deser = (JsonDeserializer<Object>)seen.get(type);
                }
                if (deser == null) {
                    deser = this.findDeserializer(config, provider, type, prop.getPropertyName(), seen);
                }
                prop.setValueDeserializer(deser);
            }
        }
    }

    @Override
    public final Object deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            return this.deserializeFromObject(jp, ctxt);
        }
        if (t == JsonToken.VALUE_STRING) {
            return this.deserializeFromString(jp, ctxt);
        }
        if (t.isNumeric()) {
            return this.deserializeFromNumber(jp, ctxt);
        }
        throw ctxt.mappingException(this.getBeanClass());
    }

    public final Class<?> getBeanClass() {
        return this._beanType.getRawClass();
    }

    public Object deserializeFromObject(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Object bean;
        if (this._defaultConstructor == null) {
            if (this._propertyBasedCreator != null) {
                return this._deserializeUsingPropertyBased(jp, ctxt);
            }
            if (this._delegatingCreator != null) {
                return this._delegatingCreator.deserialize(jp, ctxt);
            }
            throw JsonMappingException.from(jp, "No default constructor found for type " + this._beanType + ": can not instantiate from Json object");
        }
        try {
            bean = this._defaultConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            ClassUtil.unwrapAndThrowAsIAE(e);
            return null;
        }
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String propName = jp.getCurrentName();
            SettableBeanProperty prop = this._props.get(propName);
            if (prop != null) {
                prop.deserializeAndSet(jp, ctxt, bean);
                continue;
            }
            if (this._anySetter != null) {
                this._anySetter.deserializeAndSet(jp, ctxt, bean, propName);
                continue;
            }
            jp.nextToken();
            this.handleUnknownProperty(ctxt, bean, propName);
        }
        return bean;
    }

    public Object deserializeFromString(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (this._stringCreator != null) {
            return this._stringCreator.construct(jp.getText());
        }
        if (this._delegatingCreator != null) {
            return this._delegatingCreator.deserialize(jp, ctxt);
        }
        throw ctxt.mappingException(this.getBeanClass());
    }

    public Object deserializeFromNumber(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (this._numberCreator != null) {
            switch (jp.getNumberType()) {
                case INT: {
                    return this._numberCreator.construct(jp.getIntValue());
                }
                case LONG: {
                    return this._numberCreator.construct(jp.getLongValue());
                }
            }
        }
        if (this._delegatingCreator != null) {
            return this._delegatingCreator.deserialize(jp, ctxt);
        }
        throw ctxt.mappingException(this.getBeanClass());
    }

    protected final Object _deserializeUsingPropertyBased(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        PropertyBasedCreator creator = this._propertyBasedCreator;
        PropertyBuffer buffer = creator.startBuilding(jp, ctxt);
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String propName = jp.getCurrentName();
            SettableBeanProperty prop = creator.findCreatorProperty(propName);
            if (prop != null) {
                if (!buffer.assignParameter(prop.getCreatorIndex(), prop.deserialize(jp, ctxt))) continue;
                return this._deserializeProperties(jp, ctxt, creator.build(buffer));
            }
            prop = this._props.get(propName);
            if (prop != null) {
                buffer.bufferProperty(prop, prop.deserialize(jp, ctxt));
                continue;
            }
            if (this._anySetter != null) {
                buffer.bufferAnyProperty(this._anySetter, propName, this._anySetter.deserialize(jp, ctxt));
                continue;
            }
            jp.nextToken();
            this.handleUnknownProperty(ctxt, this.getBeanClass(), propName);
        }
        return creator.build(buffer);
    }

    protected Object _deserializeProperties(JsonParser jp, DeserializationContext ctxt, Object bean) throws IOException, JsonProcessingException {
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String propName = jp.getCurrentName();
            SettableBeanProperty prop = this._props.get(propName);
            if (prop != null) {
                prop.deserializeAndSet(jp, ctxt, bean);
                continue;
            }
            if (this._anySetter != null) {
                this._anySetter.deserializeAndSet(jp, ctxt, bean, propName);
                continue;
            }
            jp.nextToken();
            this.handleUnknownProperty(ctxt, bean, propName);
        }
        return bean;
    }

    @Override
    protected void handleUnknownProperty(DeserializationContext ctxt, Object beanOrClass, String propName) throws IOException, JsonProcessingException {
        if (this._ignorableProps != null && this._ignorableProps.contains(propName)) {
            ctxt.getParser().skipChildren();
            return;
        }
        super.handleUnknownProperty(ctxt, beanOrClass, propName);
    }

    protected JsonDeserializer<Object> findDeserializer(DeserializationConfig config, DeserializerProvider provider, JavaType type, String propertyName, HashMap<JavaType, JsonDeserializer<Object>> seen) throws JsonMappingException {
        JsonDeserializer<Object> deser = provider.findValueDeserializer(config, type, this._beanType, propertyName);
        if (deser instanceof BeanDeserializer) {
            if (seen == null) {
                seen = new HashMap();
            }
            seen.put(type, deser);
        }
        return deser;
    }

    static final class AnyPropValue
    extends PropValue {
        final SettableAnyProperty _property;
        final String _propertyName;

        public AnyPropValue(PropValue next, Object value, SettableAnyProperty prop, String propName) {
            super(next, value);
            this._property = prop;
            this._propertyName = propName;
        }

        public void assign(Object bean) throws IOException, JsonProcessingException {
            this._property.set(bean, this._propertyName, this.value);
        }
    }

    static final class RegularPropValue
    extends PropValue {
        final SettableBeanProperty _property;

        public RegularPropValue(PropValue next, Object value, SettableBeanProperty prop) {
            super(next, value);
            this._property = prop;
        }

        public void assign(Object bean) throws IOException, JsonProcessingException {
            this._property.set(bean, this.value);
        }
    }

    static abstract class PropValue {
        public final PropValue next;
        public final Object value;

        protected PropValue(PropValue next, Object value) {
            this.next = next;
            this.value = value;
        }

        public abstract void assign(Object var1) throws IOException, JsonProcessingException;
    }

    static final class PropertyBuffer {
        final JsonParser _parser;
        final DeserializationContext _context;
        final Object[] _creatorParameters;
        private int _paramsNeeded;
        private PropValue _buffered;

        public PropertyBuffer(JsonParser jp, DeserializationContext ctxt, int paramCount) {
            this._parser = jp;
            this._context = ctxt;
            this._paramsNeeded = paramCount;
            this._creatorParameters = new Object[paramCount];
        }

        protected final Object[] getParameters() {
            return this._creatorParameters;
        }

        protected PropValue buffered() {
            return this._buffered;
        }

        public boolean assignParameter(int index, Object value) {
            this._creatorParameters[index] = value;
            return --this._paramsNeeded <= 0;
        }

        public void bufferProperty(SettableBeanProperty prop, Object value) {
            this._buffered = new RegularPropValue(this._buffered, value, prop);
        }

        public void bufferAnyProperty(SettableAnyProperty prop, String propName, Object value) {
            this._buffered = new AnyPropValue(this._buffered, value, prop, propName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class PropertyBasedCreator {
        protected final Constructor<?> _ctor;
        protected final Method _factoryMethod;
        protected final HashMap<String, SettableBeanProperty> _properties;

        public PropertyBasedCreator(AnnotatedConstructor ctor, SettableBeanProperty[] ctorProps, AnnotatedMethod factory, SettableBeanProperty[] factoryProps) {
            SettableBeanProperty[] props;
            if (ctor != null) {
                this._ctor = ctor.getAnnotated();
                this._factoryMethod = null;
                props = ctorProps;
            } else if (factory != null) {
                this._ctor = null;
                this._factoryMethod = factory.getAnnotated();
                props = factoryProps;
            } else {
                throw new IllegalArgumentException("Internal error: neither delegating constructor nor factory method passed");
            }
            this._properties = new HashMap();
            for (SettableBeanProperty prop : props) {
                this._properties.put(prop.getPropertyName(), prop);
            }
        }

        public Collection<SettableBeanProperty> properties() {
            return this._properties.values();
        }

        public SettableBeanProperty findCreatorProperty(String name) {
            return this._properties.get(name);
        }

        public PropertyBuffer startBuilding(JsonParser jp, DeserializationContext ctxt) {
            return new PropertyBuffer(jp, ctxt, this._properties.size());
        }

        public Object build(PropertyBuffer buffer) throws IOException, JsonProcessingException {
            Object bean;
            try {
                bean = this._ctor != null ? this._ctor.newInstance(buffer.getParameters()) : this._factoryMethod.invoke(null, buffer.getParameters());
            }
            catch (Exception e) {
                ClassUtil.unwrapAndThrowAsIAE(e);
                return null;
            }
            PropValue pv = buffer.buffered();
            while (pv != null) {
                pv.assign(bean);
                pv = pv.next;
            }
            return bean;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class DelegatingCreator {
        protected final JavaType _valueType;
        protected final Constructor<?> _ctor;
        protected final Method _factoryMethod;
        protected JsonDeserializer<Object> _deserializer;

        public DelegatingCreator(AnnotatedConstructor ctor, AnnotatedMethod factory) {
            if (ctor != null) {
                this._ctor = ctor.getAnnotated();
                this._factoryMethod = null;
                this._valueType = TypeFactory.fromType(ctor.getParameterType(0));
            } else if (factory != null) {
                this._ctor = null;
                this._factoryMethod = factory.getAnnotated();
                this._valueType = TypeFactory.fromType(factory.getParameterType(0));
            } else {
                throw new IllegalArgumentException("Internal error: neither delegating constructor nor factory method passed");
            }
        }

        public JavaType getValueType() {
            return this._valueType;
        }

        public void setDeserializer(JsonDeserializer<Object> deser) {
            this._deserializer = deser;
        }

        public Object deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            Object value = this._deserializer.deserialize(jp, ctxt);
            try {
                if (this._ctor != null) {
                    return this._ctor.newInstance(value);
                }
                return this._factoryMethod.invoke(null, value);
            }
            catch (Exception e) {
                ClassUtil.unwrapAndThrowAsIAE(e);
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class NumberCreator {
        protected final Class<?> _valueClass;
        protected final Constructor<?> _intCtor;
        protected final Constructor<?> _longCtor;
        protected final Method _intFactoryMethod;
        protected final Method _longFactoryMethod;

        public NumberCreator(Class<?> valueClass, AnnotatedConstructor intCtor, AnnotatedMethod ifm, AnnotatedConstructor longCtor, AnnotatedMethod lfm) {
            this._valueClass = valueClass;
            this._intCtor = intCtor == null ? null : intCtor.getAnnotated();
            this._longCtor = longCtor == null ? null : longCtor.getAnnotated();
            this._intFactoryMethod = ifm == null ? null : ifm.getAnnotated();
            this._longFactoryMethod = lfm == null ? null : lfm.getAnnotated();
        }

        public Object construct(int value) {
            try {
                if (this._intCtor != null) {
                    return this._intCtor.newInstance(value);
                }
                if (this._intFactoryMethod != null) {
                    return this._intFactoryMethod.invoke(this._valueClass, value);
                }
            }
            catch (Exception e) {
                ClassUtil.unwrapAndThrowAsIAE(e);
            }
            return this.construct((long)value);
        }

        public Object construct(long value) {
            try {
                if (this._longCtor != null) {
                    return this._longCtor.newInstance(value);
                }
                if (this._longFactoryMethod != null) {
                    return this._longFactoryMethod.invoke(this._valueClass, value);
                }
            }
            catch (Exception e) {
                ClassUtil.unwrapAndThrowAsIAE(e);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class StringCreator {
        protected final Class<?> _valueClass;
        protected final Method _factoryMethod;
        protected final Constructor<?> _ctor;

        public StringCreator(Class<?> valueClass, AnnotatedConstructor ctor, AnnotatedMethod factoryMethod) {
            this._valueClass = valueClass;
            this._ctor = ctor == null ? null : ctor.getAnnotated();
            this._factoryMethod = factoryMethod == null ? null : factoryMethod.getAnnotated();
        }

        public Object construct(String value) {
            try {
                if (this._ctor != null) {
                    return this._ctor.newInstance(value);
                }
                if (this._factoryMethod != null) {
                    return this._factoryMethod.invoke(this._valueClass, value);
                }
            }
            catch (Exception e) {
                ClassUtil.unwrapAndThrowAsIAE(e);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CreatorContainer {
        final Class<?> _beanClass;
        final boolean _canFixAccess;
        AnnotatedMethod _strFactory;
        AnnotatedMethod _intFactory;
        AnnotatedMethod _longFactory;
        AnnotatedMethod _delegatingFactory;
        AnnotatedMethod _propertyBasedFactory;
        SettableBeanProperty[] _propertyBasedFactoryProperties = null;
        AnnotatedConstructor _strConstructor;
        AnnotatedConstructor _intConstructor;
        AnnotatedConstructor _longConstructor;
        AnnotatedConstructor _delegatingConstructor;
        AnnotatedConstructor _propertyBasedConstructor;
        SettableBeanProperty[] _propertyBasedConstructorProperties = null;

        public CreatorContainer(Class<?> beanClass, boolean canFixAccess) {
            this._canFixAccess = canFixAccess;
            this._beanClass = beanClass;
        }

        public void addStringConstructor(AnnotatedConstructor ctor) {
            this._strConstructor = this.verifyNonDup(ctor, this._strConstructor, "String");
        }

        public void addIntConstructor(AnnotatedConstructor ctor) {
            this._intConstructor = this.verifyNonDup(ctor, this._intConstructor, "int");
        }

        public void addLongConstructor(AnnotatedConstructor ctor) {
            this._longConstructor = this.verifyNonDup(ctor, this._longConstructor, "long");
        }

        public void addDelegatingConstructor(AnnotatedConstructor ctor) {
            this._delegatingConstructor = this.verifyNonDup(ctor, this._delegatingConstructor, "long");
        }

        public void addPropertyConstructor(AnnotatedConstructor ctor, SettableBeanProperty[] properties) {
            this._propertyBasedConstructor = this.verifyNonDup(ctor, this._propertyBasedConstructor, "property-based");
            this._propertyBasedConstructorProperties = properties;
        }

        public void addStringFactory(AnnotatedMethod factory) {
            this._strFactory = this.verifyNonDup(factory, this._strFactory, "String");
        }

        public void addIntFactory(AnnotatedMethod factory) {
            this._intFactory = this.verifyNonDup(factory, this._intFactory, "int");
        }

        public void addLongFactory(AnnotatedMethod factory) {
            this._longFactory = this.verifyNonDup(factory, this._longFactory, "long");
        }

        public void addDelegatingFactory(AnnotatedMethod factory) {
            this._delegatingFactory = this.verifyNonDup(factory, this._delegatingFactory, "long");
        }

        public void addPropertyFactory(AnnotatedMethod factory, SettableBeanProperty[] properties) {
            this._propertyBasedFactory = this.verifyNonDup(factory, this._propertyBasedFactory, "property-based");
            this._propertyBasedFactoryProperties = properties;
        }

        public StringCreator stringCreator() {
            if (this._strConstructor == null && this._strFactory == null) {
                return null;
            }
            return new StringCreator(this._beanClass, this._strConstructor, this._strFactory);
        }

        public NumberCreator numberCreator() {
            if (this._intConstructor == null && this._intFactory == null || this._longConstructor == null && this._longFactory == null) {
                return null;
            }
            return new NumberCreator(this._beanClass, this._intConstructor, this._intFactory, this._longConstructor, this._longFactory);
        }

        public DelegatingCreator delegatingCreator() {
            if (this._delegatingConstructor == null && this._delegatingFactory == null) {
                return null;
            }
            return new DelegatingCreator(this._delegatingConstructor, this._delegatingFactory);
        }

        public PropertyBasedCreator propertyBasedCreator() {
            if (this._propertyBasedConstructor == null && this._propertyBasedFactory == null) {
                return null;
            }
            return new PropertyBasedCreator(this._propertyBasedConstructor, this._propertyBasedConstructorProperties, this._propertyBasedFactory, this._propertyBasedFactoryProperties);
        }

        protected AnnotatedConstructor verifyNonDup(AnnotatedConstructor newOne, AnnotatedConstructor oldOne, String type) {
            if (oldOne != null) {
                throw new IllegalArgumentException("Conflicting " + type + " constructors: already had " + oldOne + ", encountered " + newOne);
            }
            if (this._canFixAccess) {
                ClassUtil.checkAndFixAccess((Member)((Object)newOne.getAnnotated()));
            }
            return newOne;
        }

        protected AnnotatedMethod verifyNonDup(AnnotatedMethod newOne, AnnotatedMethod oldOne, String type) {
            if (oldOne != null) {
                throw new IllegalArgumentException("Conflicting " + type + " factory methods: already had " + oldOne + ", encountered " + newOne);
            }
            if (this._canFixAccess) {
                ClassUtil.checkAndFixAccess(newOne.getAnnotated());
            }
            return newOne;
        }
    }
}

