/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.introspect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.codehaus.jackson.map.introspect.Annotated;
import org.codehaus.jackson.map.introspect.AnnotationMap;
import org.codehaus.jackson.map.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotatedMethod
extends Annotated {
    Method _method;
    final AnnotationMap _annotations = new AnnotationMap();

    public AnnotatedMethod(Method method) {
        this._method = method;
        for (Annotation a : method.getDeclaredAnnotations()) {
            this._annotations.add(a);
        }
    }

    public void addAnnotationsNotPresent(Method method) {
        for (Annotation a : method.getDeclaredAnnotations()) {
            this._annotations.addIfNotPresent(a);
        }
    }

    @Override
    public Method getAnnotated() {
        return this._method;
    }

    @Override
    public int getModifiers() {
        return this._method.getModifiers();
    }

    @Override
    public String getName() {
        return this._method.getName();
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> acls) {
        return this._annotations.get(acls);
    }

    public Type[] getGenericParameterTypes() {
        return this._method.getGenericParameterTypes();
    }

    public Class<?>[] getParameterTypes() {
        return this._method.getParameterTypes();
    }

    public Class<?> getReturnType() {
        return this._method.getReturnType();
    }

    public Class<?> getDeclaringClass() {
        return this._method.getDeclaringClass();
    }

    public String getFullName() {
        return this.getDeclaringClass().getName() + "#" + this.getName();
    }

    public <A extends Annotation> boolean hasAnnotation(Class<A> acls) {
        return this._annotations.get(acls) != null;
    }

    public int getAnnotationCount() {
        return this._annotations.size();
    }

    public void fixAccess() {
        ClassUtil.checkAndFixAccess(this._method);
    }

    public String toString() {
        return "[method " + this.getName() + ", annotations: " + this._annotations + "]";
    }
}

