/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.deser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.deser.StdDeserializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UntypedObjectDeserializer
extends StdDeserializer<Object> {
    public UntypedObjectDeserializer() {
        super(Object.class);
    }

    @Override
    public Object deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        switch (jp.getCurrentToken()) {
            case VALUE_STRING: {
                return jp.getText();
            }
            case VALUE_NUMBER_INT: {
                return jp.getNumberValue();
            }
            case VALUE_NUMBER_FLOAT: {
                if (ctxt.isEnabled(DeserializationConfig.Feature.USE_BIG_DECIMAL_FOR_FLOATS)) {
                    return jp.getDecimalValue();
                }
                return jp.getDoubleValue();
            }
            case VALUE_TRUE: {
                return Boolean.TRUE;
            }
            case VALUE_FALSE: {
                return Boolean.FALSE;
            }
            case VALUE_NULL: {
                return null;
            }
            case START_ARRAY: {
                return this.mapArray(jp, ctxt);
            }
            case START_OBJECT: {
                return this.mapObject(jp, ctxt);
            }
        }
        throw ctxt.mappingException(Object.class);
    }

    protected List<Object> mapArray(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ArrayList<Object> result = new ArrayList<Object>();
        while (jp.nextToken() != JsonToken.END_ARRAY) {
            result.add(this.deserialize(jp, ctxt));
        }
        return result;
    }

    protected Map<String, Object> mapObject(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken currToken;
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        while ((currToken = jp.nextToken()) != JsonToken.END_OBJECT) {
            if (currToken != JsonToken.FIELD_NAME) {
                throw JsonMappingException.from(jp, "Unexpected token (" + currToken + "), expected FIELD_NAME");
            }
            String fieldName = jp.getText();
            jp.nextToken();
            result.put(fieldName, this.deserialize(jp, ctxt));
        }
        return result;
    }
}

