/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map;

import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonWriteNullProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializationConfig {
    protected static final int DEFAULT_FEATURE_FLAGS = Feature.collectDefaults();
    protected int _featureFlags = DEFAULT_FEATURE_FLAGS;

    public SerializationConfig() {
    }

    private SerializationConfig(int f) {
        this._featureFlags = f;
    }

    public SerializationConfig createUnshared() {
        return new SerializationConfig(this._featureFlags);
    }

    public void fromAnnotations(Class<?> annotatedClass) {
        JsonAutoDetect autoDetect;
        JsonWriteNullProperties nullProps = annotatedClass.getAnnotation(JsonWriteNullProperties.class);
        if (nullProps != null) {
            this.set(Feature.OUTPUT_NULL_PROPERTIES, nullProps.value());
        }
        if ((autoDetect = annotatedClass.getAnnotation(JsonAutoDetect.class)) != null) {
            boolean set = false;
            for (JsonMethod m : autoDetect.value()) {
                if (m != JsonMethod.GETTER && m != JsonMethod.ALL) continue;
                set = true;
                break;
            }
            this.set(Feature.AUTO_DETECT_GETTERS, set);
        }
    }

    public final boolean isEnabled(Feature f) {
        return (this._featureFlags & f.getMask()) != 0;
    }

    public void enable(Feature f) {
        this._featureFlags |= f.getMask();
    }

    public void disable(Feature f) {
        this._featureFlags &= ~f.getMask();
    }

    public void set(Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
    }

    public String toString() {
        return "[SerializationConfig: flags=0x" + Integer.toHexString(this._featureFlags) + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Feature {
        AUTO_DETECT_GETTERS(true),
        OUTPUT_NULL_PROPERTIES(true);

        final boolean _defaultState;

        public static int collectDefaults() {
            int flags = 0;
            for (Feature f : Feature.values()) {
                if (!f.enabledByDefault()) continue;
                flags |= f.getMask();
            }
            return flags;
        }

        private Feature(boolean defaultState) {
            this._defaultState = defaultState;
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public int getMask() {
            return 1 << this.ordinal();
        }
    }
}

