/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.node;

import java.io.IOException;
import java.math.BigDecimal;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.BinaryNode;
import org.codehaus.jackson.node.BooleanNode;
import org.codehaus.jackson.node.DecimalNode;
import org.codehaus.jackson.node.DoubleNode;
import org.codehaus.jackson.node.IntNode;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.codehaus.jackson.node.LongNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.NumericNode;
import org.codehaus.jackson.node.ObjectNode;
import org.codehaus.jackson.node.TextNode;

public abstract class TreeMapperBase
implements JsonNodeFactory {
    protected DupFields _cfgDupFields = DupFields.ERROR;

    protected TreeMapperBase() {
    }

    public ArrayNode arrayNode() {
        return new ArrayNode(this);
    }

    public ObjectNode objectNode() {
        return new ObjectNode(this);
    }

    public NullNode nullNode() {
        return NullNode.getInstance();
    }

    public TextNode textNode(String text) {
        return TextNode.valueOf(text);
    }

    public BinaryNode binaryNode(byte[] data) {
        return BinaryNode.valueOf(data);
    }

    public BinaryNode binaryNode(byte[] data, int offset, int length) {
        return BinaryNode.valueOf(data, offset, length);
    }

    public BooleanNode booleanNode(boolean v) {
        return v ? BooleanNode.getTrue() : BooleanNode.getFalse();
    }

    public NumericNode numberNode(byte v) {
        return IntNode.valueOf(v);
    }

    public NumericNode numberNode(short v) {
        return IntNode.valueOf(v);
    }

    public NumericNode numberNode(int v) {
        return IntNode.valueOf(v);
    }

    public NumericNode numberNode(long v) {
        return LongNode.valueOf(v);
    }

    public NumericNode numberNode(float v) {
        return DoubleNode.valueOf(v);
    }

    public NumericNode numberNode(double v) {
        return DoubleNode.valueOf(v);
    }

    public NumericNode numberNode(BigDecimal v) {
        return DecimalNode.valueOf(v);
    }

    protected JsonNode _readAndMap(JsonParser jp, JsonToken currToken) throws IOException, JsonParseException {
        switch (currToken) {
            case START_OBJECT: {
                ObjectNode node = this.objectNode();
                while ((currToken = jp.nextToken()) != JsonToken.END_OBJECT) {
                    if (currToken != JsonToken.FIELD_NAME) {
                        this._reportProblem(jp, "Unexpected token (" + currToken + "), expected FIELD_NAME");
                    }
                    String fieldName = jp.getText();
                    JsonNode value = this._readAndMap(jp, jp.nextToken());
                    if (this._cfgDupFields == DupFields.ERROR) {
                        JsonNode old = node.put(fieldName, value);
                        if (old == null) continue;
                        this._reportProblem(jp, "Duplicate value for field '" + fieldName + "', when dup fields mode is " + (Object)((Object)this._cfgDupFields));
                        continue;
                    }
                    if (this._cfgDupFields == DupFields.USE_LAST) {
                        node.put(fieldName, value);
                        continue;
                    }
                    if (node.get(fieldName) != null) continue;
                    node.put(fieldName, value);
                }
                return node;
            }
            case START_ARRAY: {
                ArrayNode node = this.arrayNode();
                while ((currToken = jp.nextToken()) != JsonToken.END_ARRAY) {
                    JsonNode value = this._readAndMap(jp, currToken);
                    node.add(value);
                }
                return node;
            }
            case VALUE_STRING: {
                return this.textNode(jp.getText());
            }
            case VALUE_NUMBER_INT: {
                if (jp.getNumberType() == JsonParser.NumberType.INT) {
                    return this.numberNode(jp.getIntValue());
                }
                return this.numberNode(jp.getLongValue());
            }
            case VALUE_NUMBER_FLOAT: {
                if (jp.getNumberType() == JsonParser.NumberType.BIG_DECIMAL) {
                    return this.numberNode(jp.getDecimalValue());
                }
                return this.numberNode(jp.getDoubleValue());
            }
            case VALUE_TRUE: {
                return this.booleanNode(true);
            }
            case VALUE_FALSE: {
                return this.booleanNode(false);
            }
            case VALUE_NULL: {
                return this.nullNode();
            }
            case FIELD_NAME: 
            case END_OBJECT: 
            case END_ARRAY: {
                this._reportProblem(jp, "Can not map token " + currToken + ": stream off by a token or two?");
            }
        }
        this._throwInternal("Unrecognized event type: " + currToken);
        return null;
    }

    protected void _throwInternal(String msg) {
        throw new RuntimeException("Internal error: " + msg);
    }

    protected void _reportProblem(JsonParser jp, String msg) throws JsonParseException {
        throw new JsonParseException(msg, jp.getTokenLocation());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DupFields {
        ERROR,
        USE_FIRST,
        USE_LAST;

    }
}

