/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.node;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ContainerNode;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.codehaus.jackson.node.MissingNode;
import org.codehaus.jackson.node.ObjectNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArrayNode
extends ContainerNode {
    ArrayList<JsonNode> _children;

    public ArrayNode(JsonNodeFactory nc) {
        super(nc);
    }

    public boolean isArray() {
        return true;
    }

    @Override
    public int size() {
        return this._children == null ? 0 : this._children.size();
    }

    public Iterator<JsonNode> getElements() {
        return this._children == null ? ContainerNode.NoNodesIterator.instance() : this._children.iterator();
    }

    @Override
    public JsonNode get(int index) {
        if (index >= 0 && this._children != null && index < this._children.size()) {
            return this._children.get(index);
        }
        return null;
    }

    @Override
    public JsonNode get(String fieldName) {
        return null;
    }

    public JsonNode path(String fieldName) {
        return MissingNode.getInstance();
    }

    public JsonNode path(int index) {
        if (index >= 0 && this._children != null && index < this._children.size()) {
            return this._children.get(index);
        }
        return MissingNode.getInstance();
    }

    public void writeTo(JsonGenerator jg) throws IOException, JsonGenerationException {
        jg.writeStartArray();
        if (this._children != null) {
            for (JsonNode n : this._children) {
                n.writeTo(jg);
            }
        }
        jg.writeEndArray();
    }

    public JsonNode set(int index, JsonNode value) {
        if (value == null) {
            value = this.nullNode();
        }
        return this._set(index, value);
    }

    public void add(JsonNode value) {
        if (value == null) {
            value = this.nullNode();
        }
        this._add(value);
    }

    public void insert(int index, JsonNode value) {
        if (this._children == null) {
            this._children = new ArrayList();
            this._children.add(value);
            return;
        }
        if (index < 0) {
            this._children.add(0, value);
        } else if (index >= this._children.size()) {
            this._children.add(value);
        } else {
            this._children.add(index, value);
        }
    }

    public JsonNode remove(int index) {
        if (index >= 0 && this._children != null && index < this._children.size()) {
            return this._children.remove(index);
        }
        return null;
    }

    public ArrayNode addArray() {
        ArrayNode n = this.arrayNode();
        this._add(n);
        return n;
    }

    public ObjectNode addObject() {
        ObjectNode n = this.objectNode();
        this._add(n);
        return n;
    }

    public void add(String fieldName, int v) {
        this._add(this.numberNode(v));
    }

    public void add(String fieldName, long v) {
        this._add(this.numberNode(v));
    }

    public void add(String fieldName, float v) {
        this._add(this.numberNode(v));
    }

    public void add(String fieldName, double v) {
        this._add(this.numberNode(v));
    }

    public void add(String fieldName, BigDecimal v) {
        this._add(this.numberNode(v));
    }

    public void add(String fieldName, String v) {
        this._add(this.textNode(v));
    }

    public void add(String fieldName, boolean v) {
        this._add(this.booleanNode(v));
    }

    public void add(String fieldName, byte[] v) {
        this._add(this.binaryNode(v));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        ArrayNode other = (ArrayNode)o;
        if (this._children == null) {
            return other._children == null;
        }
        return other._sameChildren(this._children);
    }

    public int hashCode() {
        int hash;
        if (this._children == null) {
            hash = 1;
        } else {
            hash = this._children.size();
            for (JsonNode n : this._children) {
                if (n == null) continue;
                hash ^= n.hashCode();
            }
        }
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(16 + (this.size() << 4));
        sb.append('[');
        if (this._children != null) {
            int len = this._children.size();
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(this._children.get(i).toString());
            }
        }
        sb.append(']');
        return sb.toString();
    }

    public JsonNode _set(int index, JsonNode value) {
        if (this._children == null || index < 0 || index >= this._children.size()) {
            throw new IndexOutOfBoundsException("Illegal index " + index + ", array size " + this.size());
        }
        return this._children.set(index, value);
    }

    private void _add(JsonNode node) {
        if (this._children == null) {
            this._children = new ArrayList();
        }
        this._children.add(node);
    }

    private boolean _sameChildren(ArrayList<JsonNode> otherChildren) {
        int len = otherChildren.size();
        if (this._children.size() != len) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this._children.get(i).equals((Object)otherChildren.get(i))) continue;
            return false;
        }
        return true;
    }
}

