/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.ser;

import java.io.IOException;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.ResolvableSerializer;
import org.codehaus.jackson.map.SerializerFactory;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.ser.FailingSerializer;
import org.codehaus.jackson.map.ser.ReadOnlyClassToSerializerMap;
import org.codehaus.jackson.map.ser.SerializerCache;
import org.codehaus.jackson.map.ser.StdKeySerializer;
import org.codehaus.jackson.map.ser.StdSerializerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StdSerializerProvider
extends SerializerProvider {
    static final boolean CACHE_UNKNOWN_MAPPINGS = false;
    public static final JsonSerializer<Object> DEFAULT_NULL_KEY_SERIALIZER = new FailingSerializer("Null key for a Map not allower in Json (use a converting NullKeySerializer?)");
    public static final JsonSerializer<Object> DEFAULT_KEY_SERIALIZER = new StdKeySerializer();
    public static final JsonSerializer<Object> DEFAULT_UNKNOWN_SERIALIZER = new JsonSerializer<Object>(){

        @Override
        public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            throw new JsonGenerationException("No serializer found for class " + value.getClass().getName());
        }
    };
    protected final SerializerFactory _serializerFactory;
    protected final SerializerCache _serializerCache;
    protected JsonSerializer<Object> _unknownTypeSerializer = DEFAULT_UNKNOWN_SERIALIZER;
    protected JsonSerializer<Object> _keySerializer = DEFAULT_KEY_SERIALIZER;
    protected JsonSerializer<Object> _nullValueSerializer = StdSerializerFactory.NullSerializer.instance;
    protected JsonSerializer<Object> _nullKeySerializer = DEFAULT_NULL_KEY_SERIALIZER;
    protected final ReadOnlyClassToSerializerMap _knownSerializers;

    public StdSerializerProvider() {
        this._serializerFactory = null;
        this._serializerCache = new SerializerCache();
        this._knownSerializers = null;
    }

    protected StdSerializerProvider(StdSerializerProvider src, SerializerFactory f) {
        this._serializerFactory = f;
        this._serializerCache = src._serializerCache;
        this._unknownTypeSerializer = src._unknownTypeSerializer;
        this._keySerializer = src._keySerializer;
        this._nullValueSerializer = src._nullValueSerializer;
        this._nullKeySerializer = src._nullKeySerializer;
        this._knownSerializers = this._serializerCache.getReadOnlyLookupMap();
    }

    protected StdSerializerProvider createInstance(SerializerFactory jsf) {
        return new StdSerializerProvider(this, jsf);
    }

    @Override
    public final void serializeValue(JsonGenerator jgen, Object value, SerializerFactory jsf) throws IOException, JsonGenerationException {
        if (jsf == null) {
            throw new IllegalArgumentException("Can not pass null serializerFactory");
        }
        StdSerializerProvider inst = this.createInstance(jsf);
        if (inst.getClass() != this.getClass()) {
            throw new IllegalStateException("Broken serializer provider: createInstance returned instance of type " + inst.getClass() + "; blueprint of type " + this.getClass());
        }
        inst._serializeValue(jgen, value);
    }

    protected void _serializeValue(JsonGenerator jgen, Object value) throws IOException, JsonGenerationException {
        JsonSerializer<Object> ser = value == null ? this.getNullValueSerializer() : this.findValueSerializer(value.getClass());
        ser.serialize(value, jgen, this);
    }

    public void setKeySerializer(JsonSerializer<Object> ks) {
        if (ks == null) {
            throw new IllegalArgumentException("Can not pass null JsonSerializer");
        }
        this._keySerializer = ks;
    }

    public void setNullValueSerializer(JsonSerializer<Object> nvs) {
        if (nvs == null) {
            throw new IllegalArgumentException("Can not pass null JsonSerializer");
        }
        this._nullValueSerializer = nvs;
    }

    public void setNullKeySerializer(JsonSerializer<Object> nks) {
        if (nks == null) {
            throw new IllegalArgumentException("Can not pass null JsonSerializer");
        }
        this._nullKeySerializer = nks;
    }

    @Override
    public JsonSerializer<Object> findValueSerializer(Class<?> type) throws JsonMappingException {
        JsonSerializer<Object> ser = this._knownSerializers.get(type);
        if (ser != null) {
            return ser;
        }
        ser = this._serializerCache.findSerializer(type);
        if (ser != null) {
            return ser;
        }
        try {
            ser = this._createSerializer(type);
        }
        catch (IllegalArgumentException iae) {
            throw new JsonMappingException(iae.getMessage(), null, iae);
        }
        if (ser == null) {
            ser = this.getUnknownTypeSerializer(type);
            return ser;
        }
        this._serializerCache.addSerializer(type, ser);
        if (ser instanceof ResolvableSerializer) {
            this._resolveSerializer((ResolvableSerializer)((Object)ser));
        }
        return ser;
    }

    @Override
    public JsonSerializer<Object> getKeySerializer() {
        return this._keySerializer;
    }

    @Override
    public JsonSerializer<Object> getNullKeySerializer() {
        return this._nullKeySerializer;
    }

    @Override
    public JsonSerializer<Object> getNullValueSerializer() {
        return this._nullValueSerializer;
    }

    @Override
    public JsonSerializer<Object> getUnknownTypeSerializer(Class<?> unknownType) {
        return this._unknownTypeSerializer;
    }

    protected JsonSerializer<Object> _createSerializer(Class<?> type) throws JsonMappingException {
        return this._serializerFactory.createSerializer(type);
    }

    protected void _resolveSerializer(ResolvableSerializer ser) throws JsonMappingException {
        ser.resolve(this);
    }
}

