/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.net.URL;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.impl.ByteSourceBootstrapper;
import org.codehaus.jackson.impl.ReaderBasedParser;
import org.codehaus.jackson.impl.WriterBasedGenerator;
import org.codehaus.jackson.io.IOContext;
import org.codehaus.jackson.io.UTF8Writer;
import org.codehaus.jackson.sym.NameCanonicalizer;
import org.codehaus.jackson.sym.SymbolTable;
import org.codehaus.jackson.util.BufferRecycler;

public final class JsonFactory {
    static final int DEFAULT_PARSER_FEATURE_FLAGS = JsonParser.Feature.collectDefaults();
    static final int DEFAULT_GENERATOR_FEATURE_FLAGS = JsonGenerator.Feature.collectDefaults();
    static final ThreadLocal<SoftReference<BufferRecycler>> _recyclerRef = new ThreadLocal();
    private SymbolTable _charSymbols = SymbolTable.createRoot();
    private NameCanonicalizer _byteSymbols = NameCanonicalizer.createRoot();
    private int _parserFeatures = DEFAULT_PARSER_FEATURE_FLAGS;
    private int _generatorFeatures = DEFAULT_GENERATOR_FEATURE_FLAGS;

    public void enableParserFeature(JsonParser.Feature f) {
        this._parserFeatures |= f.getMask();
    }

    public void disableParserFeature(JsonParser.Feature f) {
        this._parserFeatures &= ~f.getMask();
    }

    public void setParserFeature(JsonParser.Feature f, boolean state) {
        if (state) {
            this.enableParserFeature(f);
        } else {
            this.disableParserFeature(f);
        }
    }

    public boolean isParserFeatureEnabled(JsonParser.Feature f) {
        return (this._parserFeatures & f.getMask()) != 0;
    }

    public void enableGeneratorFeature(JsonGenerator.Feature f) {
        this._generatorFeatures |= f.getMask();
    }

    public void disableGeneratorFeature(JsonGenerator.Feature f) {
        this._generatorFeatures &= ~f.getMask();
    }

    public void setGeneratorFeature(JsonGenerator.Feature f, boolean state) {
        if (state) {
            this.enableGeneratorFeature(f);
        } else {
            this.disableGeneratorFeature(f);
        }
    }

    public boolean isGeneratorFeatureEnabled(JsonGenerator.Feature f) {
        return (this._generatorFeatures & f.getMask()) != 0;
    }

    public JsonParser createJsonParser(File f) throws IOException, JsonParseException {
        return this._createJsonParser(new FileInputStream(f), this._createContext(f, true));
    }

    public JsonParser createJsonParser(URL url) throws IOException, JsonParseException {
        return this._createJsonParser(JsonFactory._optimizedStreamFromURL(url), this._createContext(url, true));
    }

    public JsonParser createJsonParser(InputStream in) throws IOException, JsonParseException {
        return this._createJsonParser(in, this._createContext(in, false));
    }

    public JsonParser createJsonParser(Reader r) throws IOException, JsonParseException {
        return new ReaderBasedParser(this._createContext(r, false), this._parserFeatures, r, this._charSymbols.makeChild());
    }

    public JsonParser createJsonParser(byte[] data, int offset, int len) throws IOException, JsonParseException {
        ByteArrayInputStream in = new ByteArrayInputStream(data, offset, len);
        return this._createJsonParser(in, this._createContext(in, true));
    }

    public final JsonParser createJsonParser(byte[] data) throws IOException, JsonParseException {
        return this.createJsonParser(data, 0, data.length);
    }

    public final JsonParser createJsonParser(String content) throws IOException, JsonParseException {
        StringReader r = new StringReader(content);
        return new ReaderBasedParser(this._createContext(r, true), this._parserFeatures, r, this._charSymbols.makeChild());
    }

    private JsonParser _createJsonParser(InputStream in, IOContext ctxt) throws IOException, JsonParseException {
        return new ByteSourceBootstrapper(ctxt, in).constructParser(this._parserFeatures, this._byteSymbols, this._charSymbols);
    }

    public JsonGenerator createJsonGenerator(OutputStream out, JsonEncoding enc) throws IOException {
        IOContext ctxt = this._createContext(out, false);
        ctxt.setEncoding(enc);
        if (enc == JsonEncoding.UTF8) {
            return new WriterBasedGenerator(ctxt, this._generatorFeatures, new UTF8Writer(ctxt, out));
        }
        return new WriterBasedGenerator(ctxt, this._generatorFeatures, new OutputStreamWriter(out, enc.getJavaName()));
    }

    public JsonGenerator createJsonGenerator(Writer out) throws IOException {
        IOContext ctxt = this._createContext(out, false);
        return new WriterBasedGenerator(ctxt, this._generatorFeatures, out);
    }

    public JsonGenerator createJsonGenerator(File f, JsonEncoding enc) throws IOException {
        return this.createJsonGenerator(new FileOutputStream(f), enc);
    }

    protected IOContext _createContext(Object srcRef, boolean resourceManaged) {
        return new IOContext(this._getBufferRecycler(), srcRef, resourceManaged);
    }

    protected BufferRecycler _getBufferRecycler() {
        BufferRecycler br;
        SoftReference<BufferRecycler> ref = _recyclerRef.get();
        BufferRecycler bufferRecycler = br = ref == null ? null : ref.get();
        if (br == null) {
            br = new BufferRecycler();
            if (ref == null) {
                _recyclerRef.set(new SoftReference<BufferRecycler>(br));
            }
        }
        return br;
    }

    protected static InputStream _optimizedStreamFromURL(URL url) throws IOException {
        if ("file".equals(url.getProtocol()) && url.getHost() == null) {
            return new FileInputStream(url.getPath());
        }
        return url.openStream();
    }
}

