/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.io;

import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.util.BufferRecycler;
import org.codehaus.jackson.util.TextBuffer;

public final class IOContext {
    final BufferRecycler mBufferRecycler;
    final Object mSourceRef;
    protected JsonEncoding mEncoding;
    protected byte[] mReadIOBuffer = null;
    protected byte[] mWriteIOBuffer = null;
    protected char[] mTokenBuffer = null;
    protected char[] mConcatBuffer = null;

    public IOContext(BufferRecycler br, Object sourceRef) {
        this.mBufferRecycler = br;
        this.mSourceRef = sourceRef;
    }

    public void setEncoding(JsonEncoding enc) {
        this.mEncoding = enc;
    }

    public TextBuffer constructTextBuffer() {
        return new TextBuffer(this.mBufferRecycler);
    }

    public byte[] allocReadIOBuffer() {
        if (this.mReadIOBuffer != null) {
            throw new IllegalStateException("Trying to call allocReadIOBuffer() second time");
        }
        this.mReadIOBuffer = this.mBufferRecycler.allocByteBuffer(BufferRecycler.ByteBufferType.READ_IO_BUFFER);
        return this.mReadIOBuffer;
    }

    public byte[] allocWriteIOBuffer() {
        if (this.mWriteIOBuffer != null) {
            throw new IllegalStateException("Trying to call allocWriteIOBuffer() second time");
        }
        this.mWriteIOBuffer = this.mBufferRecycler.allocByteBuffer(BufferRecycler.ByteBufferType.WRITE_IO_BUFFER);
        return this.mWriteIOBuffer;
    }

    public char[] allocTokenBuffer() {
        if (this.mTokenBuffer != null) {
            throw new IllegalStateException("Trying to call allocTokenBuffer() second time");
        }
        this.mTokenBuffer = this.mBufferRecycler.allocCharBuffer(BufferRecycler.CharBufferType.TOKEN_BUFFER);
        return this.mTokenBuffer;
    }

    public char[] allocConcatBuffer() {
        if (this.mConcatBuffer != null) {
            throw new IllegalStateException("Trying to call allocConcatBuffer() second time");
        }
        this.mConcatBuffer = this.mBufferRecycler.allocCharBuffer(BufferRecycler.CharBufferType.CONCAT_BUFFER);
        return this.mConcatBuffer;
    }

    public void releaseReadIOBuffer(byte[] buf) {
        if (buf != null) {
            if (buf != this.mReadIOBuffer) {
                throw new IllegalArgumentException("Trying to release buffer not owned by the context");
            }
            this.mReadIOBuffer = null;
            this.mBufferRecycler.releaseByteBuffer(BufferRecycler.ByteBufferType.READ_IO_BUFFER, buf);
        }
    }

    public void releaseWriteIOBuffer(byte[] buf) {
        if (buf != null) {
            if (buf != this.mWriteIOBuffer) {
                throw new IllegalArgumentException("Trying to release buffer not owned by the context");
            }
            this.mWriteIOBuffer = null;
            this.mBufferRecycler.releaseByteBuffer(BufferRecycler.ByteBufferType.WRITE_IO_BUFFER, buf);
        }
    }

    public void releaseTokenBuffer(char[] buf) {
        if (buf != null) {
            if (buf != this.mTokenBuffer) {
                throw new IllegalArgumentException("Trying to release buffer not owned by the context");
            }
            this.mTokenBuffer = null;
            this.mBufferRecycler.releaseCharBuffer(BufferRecycler.CharBufferType.TOKEN_BUFFER, buf);
        }
    }

    public void releaseConcatBuffer(char[] buf) {
        if (buf != null) {
            if (buf != this.mConcatBuffer) {
                throw new IllegalArgumentException("Trying to release buffer not owned by the context");
            }
            this.mConcatBuffer = null;
            this.mBufferRecycler.releaseCharBuffer(BufferRecycler.CharBufferType.CONCAT_BUFFER, buf);
        }
    }

    public Object getSourceReference() {
        return this.mSourceRef;
    }

    public JsonEncoding getEncoding() {
        return this.mEncoding;
    }
}

