/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.impl;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.impl.JsonGeneratorBase;
import org.codehaus.jackson.io.IOContext;
import org.codehaus.jackson.io.NumberOutput;
import org.codehaus.jackson.util.CharTypes;

public final class WriterBasedGenerator
extends JsonGeneratorBase {
    static final int SHORT_WRITE = 32;
    static final char[] HEX_CHARS = "0123456789ABCDEF".toCharArray();
    protected final IOContext mIOContext;
    protected final Writer mWriter;
    protected char[] mOutputBuffer;
    protected int mOutputHead = 0;
    protected int mOutputTail = 0;
    protected int mOutputEnd;
    protected char[] mEntityBuffer;

    public WriterBasedGenerator(IOContext ctxt, Writer w) {
        this.mIOContext = ctxt;
        this.mWriter = w;
        this.mOutputBuffer = ctxt.allocConcatBuffer();
        this.mOutputEnd = this.mOutputBuffer.length;
    }

    protected void doWriteStartArray() throws IOException, JsonGenerationException {
        if (this.mOutputTail >= this.mOutputEnd) {
            this.flushBuffer();
        }
        this.mOutputBuffer[this.mOutputTail++] = 91;
    }

    protected void doWriteEndArray() throws IOException, JsonGenerationException {
        if (this.mOutputTail >= this.mOutputEnd) {
            this.flushBuffer();
        }
        this.mOutputBuffer[this.mOutputTail++] = 93;
    }

    protected void doWriteStartObject() throws IOException, JsonGenerationException {
        if (this.mOutputTail >= this.mOutputEnd) {
            this.flushBuffer();
        }
        this.mOutputBuffer[this.mOutputTail++] = 123;
    }

    protected void doWriteEndObject() throws IOException, JsonGenerationException {
        if (this.mOutputTail >= this.mOutputEnd) {
            this.flushBuffer();
        }
        this.mOutputBuffer[this.mOutputTail++] = 125;
    }

    public void doWriteFieldName(String name, boolean commaBefore) throws IOException, JsonGenerationException {
        if (this.mPrettyPrinter != null) {
            if (commaBefore) {
                this.mPrettyPrinter.writeObjectEntrySeparator(this);
            } else {
                this.mPrettyPrinter.beforeObjectEntries(this);
            }
        } else if (commaBefore) {
            if (this.mOutputTail >= this.mOutputEnd) {
                this.flushBuffer();
            }
            this.mOutputBuffer[this.mOutputTail++] = 44;
        }
        if (this.mOutputTail >= this.mOutputEnd) {
            this.flushBuffer();
        }
        this.mOutputBuffer[this.mOutputTail++] = 34;
        this.doWriteString(name);
        if (this.mOutputTail >= this.mOutputEnd) {
            this.flushBuffer();
        }
        this.mOutputBuffer[this.mOutputTail++] = 34;
    }

    public void writeString(String text) throws IOException, JsonGenerationException {
        this.verifyValueWrite("write text value");
        if (this.mOutputTail >= this.mOutputEnd) {
            this.flushBuffer();
        }
        this.mOutputBuffer[this.mOutputTail++] = 34;
        this.doWriteString(text);
        if (this.mOutputTail >= this.mOutputEnd) {
            this.flushBuffer();
        }
        this.mOutputBuffer[this.mOutputTail++] = 34;
    }

    public void writeString(char[] text, int offset, int len) throws IOException, JsonGenerationException {
        this.verifyValueWrite("write text value");
        if (this.mOutputTail >= this.mOutputEnd) {
            this.flushBuffer();
        }
        this.mOutputBuffer[this.mOutputTail++] = 34;
        this.doWriteString(text, offset, len);
        if (this.mOutputTail >= this.mOutputEnd) {
            this.flushBuffer();
        }
        this.mOutputBuffer[this.mOutputTail++] = 34;
    }

    public void writeRaw(String text) throws IOException, JsonGenerationException {
        int len = text.length();
        int room = this.mOutputEnd - this.mOutputTail;
        if (room == 0) {
            this.flushBuffer();
            room = this.mOutputEnd - this.mOutputTail;
        }
        if (room >= len) {
            text.getChars(0, len, this.mOutputBuffer, this.mOutputTail);
            this.mOutputTail += len;
        } else {
            this.writeRawLong(text);
        }
    }

    public void writeRaw(String text, int start, int len) throws IOException, JsonGenerationException {
        int room = this.mOutputEnd - this.mOutputTail;
        if (room < len) {
            this.flushBuffer();
            room = this.mOutputEnd - this.mOutputTail;
        }
        if (room >= len) {
            text.getChars(start, start + len, this.mOutputBuffer, this.mOutputTail);
            this.mOutputTail += len;
        } else {
            this.writeRawLong(text.substring(start, start + len));
        }
    }

    public void writeRaw(char[] text, int offset, int len) throws IOException, JsonGenerationException {
        if (len < 32) {
            int room = this.mOutputEnd - this.mOutputTail;
            if (len > room) {
                this.flushBuffer();
            }
            System.arraycopy(text, offset, this.mOutputBuffer, this.mOutputTail, len);
            this.mOutputTail += len;
            return;
        }
        this.flushBuffer();
        this.mWriter.write(text, offset, len);
    }

    public void writeRaw(char c) throws IOException, JsonGenerationException {
        if (this.mOutputTail >= this.mOutputEnd) {
            this.flushBuffer();
        }
        this.mOutputBuffer[this.mOutputTail++] = c;
    }

    public void writeBinary(byte[] data, int offset, int len, boolean includeLFs) throws IOException, JsonGenerationException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    private void writeRawLong(String text) throws IOException, JsonGenerationException {
        int len;
        int amount;
        int room = this.mOutputEnd - this.mOutputTail;
        text.getChars(0, room, this.mOutputBuffer, this.mOutputTail);
        this.mOutputTail += room;
        this.flushBuffer();
        int offset = room;
        for (len = text.length() - room; len > this.mOutputEnd; len -= amount) {
            amount = this.mOutputEnd;
            text.getChars(offset, offset + amount, this.mOutputBuffer, 0);
            this.mOutputHead = 0;
            this.mOutputTail = amount;
            this.flushBuffer();
            offset += amount;
        }
        text.getChars(offset, offset + len, this.mOutputBuffer, 0);
        this.mOutputHead = 0;
        this.mOutputTail = len;
    }

    public void writeNumber(int i) throws IOException, JsonGenerationException {
        this.verifyValueWrite("write number");
        if (this.mOutputTail + 11 >= this.mOutputEnd) {
            this.flushBuffer();
        }
        this.mOutputTail = NumberOutput.outputInt(i, this.mOutputBuffer, this.mOutputTail);
    }

    public void writeNumber(long l) throws IOException, JsonGenerationException {
        this.verifyValueWrite("write number");
        if (this.mOutputTail + 21 >= this.mOutputEnd) {
            this.flushBuffer();
        }
        this.mOutputTail = NumberOutput.outputLong(l, this.mOutputBuffer, this.mOutputTail);
    }

    public void writeNumber(double d) throws IOException, JsonGenerationException {
        this.verifyValueWrite("write number");
        this.writeRaw(String.valueOf(d));
    }

    public void writeNumber(float f) throws IOException, JsonGenerationException {
        this.verifyValueWrite("write number");
        this.writeRaw(String.valueOf(f));
    }

    public void writeNumber(BigDecimal dec) throws IOException, JsonGenerationException {
        this.verifyValueWrite("write number");
        this.writeRaw(dec.toString());
    }

    public void writeNumber(String encodedValue) throws IOException, JsonGenerationException {
        this.verifyValueWrite("write number");
        this.writeRaw(encodedValue);
    }

    public void writeBoolean(boolean state) throws IOException, JsonGenerationException {
        this.verifyValueWrite("write boolean value");
        if (this.mOutputTail + 5 >= this.mOutputEnd) {
            this.flushBuffer();
        }
        int ptr = this.mOutputTail;
        char[] buf = this.mOutputBuffer;
        if (state) {
            buf[ptr] = 116;
            buf[++ptr] = 114;
            buf[++ptr] = 117;
            buf[++ptr] = 101;
        } else {
            buf[ptr] = 102;
            buf[++ptr] = 97;
            buf[++ptr] = 108;
            buf[++ptr] = 115;
            buf[++ptr] = 101;
        }
        this.mOutputTail = ptr + 1;
    }

    public void writeNull() throws IOException, JsonGenerationException {
        this.verifyValueWrite("write null value");
        if (this.mOutputTail + 4 >= this.mOutputEnd) {
            this.flushBuffer();
        }
        int ptr = this.mOutputTail;
        char[] buf = this.mOutputBuffer;
        buf[ptr] = 110;
        buf[++ptr] = 117;
        buf[++ptr] = 108;
        buf[++ptr] = 108;
        this.mOutputTail = ptr + 1;
    }

    protected final void verifyValueWrite(String typeMsg) throws IOException, JsonGenerationException {
        int status = this.mWriteContext.writeValue();
        if (status == 5) {
            this.reportError("Can not " + typeMsg + ", expecting field name");
        }
        if (this.mPrettyPrinter == null) {
            int c;
            switch (status) {
                case 1: {
                    c = 44;
                    break;
                }
                case 2: {
                    c = 58;
                    break;
                }
                case 3: {
                    c = 32;
                    break;
                }
                default: {
                    return;
                }
            }
            if (this.mOutputTail >= this.mOutputEnd) {
                this.flushBuffer();
            }
            this.mOutputBuffer[this.mOutputTail] = c;
            ++this.mOutputTail;
            return;
        }
        switch (status) {
            case 1: {
                this.mPrettyPrinter.writeArrayValueSeparator(this);
                break;
            }
            case 2: {
                this.mPrettyPrinter.writeObjectFieldValueSeparator(this);
                break;
            }
            case 3: {
                this.mPrettyPrinter.writeRootValueSeparator(this);
                break;
            }
            case 0: {
                if (this.mWriteContext.inArray()) {
                    this.mPrettyPrinter.beforeArrayValues(this);
                    break;
                }
                if (!this.mWriteContext.inObject()) break;
                this.mPrettyPrinter.beforeObjectEntries(this);
            }
        }
    }

    public final void flush() throws IOException {
        this.flushBuffer();
        this.mWriter.flush();
    }

    public void close() throws IOException {
        this.flushBuffer();
        this.mWriter.close();
        this.releaseBuffers();
    }

    protected void releaseBuffers() {
        char[] buf = this.mOutputBuffer;
        if (buf != null) {
            this.mOutputBuffer = null;
            this.mIOContext.releaseConcatBuffer(buf);
        }
    }

    private void doWriteString(String text) throws IOException, JsonGenerationException {
        int len = text.length();
        if (len > this.mOutputEnd) {
            this.doWriteLongString(text);
            return;
        }
        if (this.mOutputTail + len > this.mOutputEnd) {
            this.flushBuffer();
        }
        text.getChars(0, len, this.mOutputBuffer, this.mOutputTail);
        int end = this.mOutputTail + len;
        int[] escCodes = CharTypes.getOutputEscapes();
        int escLen = escCodes.length;
        block0: while (this.mOutputTail < end) {
            int ptr;
            int needLen;
            char c;
            while ((c = this.mOutputBuffer[this.mOutputTail]) >= escLen || escCodes[c] == 0) {
                if (++this.mOutputTail < end) continue;
                break block0;
            }
            int flushLen = this.mOutputTail - this.mOutputHead;
            if (flushLen > 0) {
                this.mWriter.write(this.mOutputBuffer, this.mOutputHead, flushLen);
            }
            int escCode = escCodes[this.mOutputBuffer[this.mOutputTail]];
            ++this.mOutputTail;
            int n = needLen = escCode < 0 ? 6 : 2;
            if (needLen > this.mOutputTail) {
                this.mOutputHead = this.mOutputTail;
                this.writeSingleEscape(escCode);
                continue;
            }
            this.mOutputHead = ptr = this.mOutputTail - needLen;
            this.appendSingleEscape(escCode, this.mOutputBuffer, ptr);
        }
    }

    private void doWriteLongString(String text) throws IOException, JsonGenerationException {
        int segmentLen;
        this.flushBuffer();
        int textLen = text.length();
        int offset = 0;
        do {
            int max;
            segmentLen = offset + (max = this.mOutputEnd) > textLen ? textLen - offset : max;
            text.getChars(offset, offset + segmentLen, this.mOutputBuffer, 0);
            this.doWriteSegment(segmentLen);
        } while ((offset += segmentLen) < textLen);
    }

    private final void doWriteSegment(int end) throws IOException, JsonGenerationException {
        int[] escCodes = CharTypes.getOutputEscapes();
        int escLen = escCodes.length;
        int ptr = 0;
        while (ptr < end) {
            int needLen;
            char c;
            int start = ptr;
            while (((c = this.mOutputBuffer[ptr]) >= escLen || escCodes[c] == 0) && ++ptr < end) {
            }
            int flushLen = ptr - start;
            if (flushLen > 0) {
                this.mWriter.write(this.mOutputBuffer, start, flushLen);
                if (ptr >= end) break;
            }
            int escCode = escCodes[this.mOutputBuffer[ptr]];
            ++ptr;
            int n = needLen = escCode < 0 ? 6 : 2;
            if (needLen > this.mOutputTail) {
                this.writeSingleEscape(escCode);
                continue;
            }
            this.appendSingleEscape(escCode, this.mOutputBuffer, ptr -= needLen);
        }
    }

    private void doWriteString(char[] text, int offset, int len) throws IOException, JsonGenerationException {
        len += offset;
        int[] escCodes = CharTypes.getOutputEscapes();
        int escLen = escCodes.length;
        while (offset < len) {
            int needLen;
            char c;
            int start = offset;
            while (((c = text[offset]) >= escLen || escCodes[c] == 0) && ++offset < len) {
            }
            int newAmount = offset - start;
            if (newAmount < 32) {
                if (this.mOutputTail + newAmount > this.mOutputEnd) {
                    this.flushBuffer();
                }
                if (newAmount > 0) {
                    System.arraycopy(text, start, this.mOutputBuffer, this.mOutputTail, newAmount);
                    this.mOutputTail += newAmount;
                }
            } else {
                this.flushBuffer();
                this.mWriter.write(text, start, newAmount);
            }
            if (offset >= len) break;
            int escCode = escCodes[text[offset]];
            ++offset;
            int n = needLen = escCode < 0 ? 6 : 2;
            if (this.mOutputTail + needLen > this.mOutputEnd) {
                this.flushBuffer();
            }
            this.appendSingleEscape(escCode, this.mOutputBuffer, this.mOutputTail);
            this.mOutputTail += needLen;
        }
    }

    private void writeSingleEscape(int escCode) throws IOException {
        char[] buf = this.mEntityBuffer;
        if (buf == null) {
            buf = new char[6];
            buf[0] = 92;
            buf[2] = 48;
            buf[3] = 48;
        }
        if (escCode < 0) {
            int value = -(escCode + 1);
            buf[1] = 117;
            buf[4] = HEX_CHARS[value >> 4];
            buf[5] = HEX_CHARS[value & 0xF];
            this.mWriter.write(buf, 0, 6);
        } else {
            buf[1] = (char)escCode;
            this.mWriter.write(buf, 0, 2);
        }
    }

    private void appendSingleEscape(int escCode, char[] buf, int ptr) {
        if (escCode < 0) {
            int value = -(escCode + 1);
            buf[ptr] = 92;
            buf[++ptr] = 117;
            buf[++ptr] = 48;
            buf[++ptr] = 48;
            buf[++ptr] = HEX_CHARS[value >> 4];
            buf[++ptr] = HEX_CHARS[value & 0xF];
        } else {
            buf[ptr] = 92;
            buf[ptr + 1] = (char)escCode;
        }
    }

    protected void flushBuffer() throws IOException {
        int len = this.mOutputTail - this.mOutputHead;
        if (len > 0) {
            int offset = this.mOutputHead;
            this.mOutputHead = 0;
            this.mOutputTail = 0;
            this.mWriter.write(this.mOutputBuffer, offset, len);
        }
    }
}

