/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.impl;

import java.io.IOException;
import java.io.Reader;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.impl.JsonNumericParserBase;
import org.codehaus.jackson.io.IOContext;

public abstract class ReaderBasedParserBase
extends JsonNumericParserBase {
    protected Reader mReader;
    protected char[] mInputBuffer;

    protected ReaderBasedParserBase(IOContext ctxt, Reader r) {
        super(ctxt);
        this.mReader = r;
        this.mInputBuffer = ctxt.allocTokenBuffer();
    }

    protected final boolean loadMore() throws IOException {
        this.mCurrInputProcessed += (long)this.mInputLast;
        this.mCurrInputRowStart -= this.mInputLast;
        if (this.mReader != null) {
            int count = this.mReader.read(this.mInputBuffer, 0, this.mInputBuffer.length);
            if (count > 0) {
                this.mInputPtr = 0;
                this.mInputLast = count;
                return true;
            }
            this.closeInput();
            if (count == 0) {
                throw new IOException("Reader returned 0 characters when trying to read " + this.mInputLast);
            }
        }
        return false;
    }

    protected char getNextChar(String eofMsg) throws IOException, JsonParseException {
        if (this.mInputPtr >= this.mInputLast && !this.loadMore()) {
            this.reportInvalidEOF(eofMsg);
        }
        return this.mInputBuffer[this.mInputPtr++];
    }

    protected void closeInput() throws IOException {
        Reader r = this.mReader;
        if (r != null) {
            this.mReader = null;
            r.close();
        }
    }

    protected void releaseBuffers() throws IOException {
        super.releaseBuffers();
        char[] buf = this.mInputBuffer;
        if (buf != null) {
            this.mInputBuffer = null;
            this.mIOContext.releaseTokenBuffer(buf);
        }
    }
}

