/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.impl;

import java.io.ByteArrayInputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.impl.Utf8StreamParser;
import org.codehaus.jackson.io.IOContext;
import org.codehaus.jackson.io.MergedStream;
import org.codehaus.jackson.io.UTF32Reader;
import org.codehaus.jackson.io.UTF8Reader;
import org.codehaus.jackson.sym.NameCanonicalizer;

public final class ByteSourceBootstrapper {
    final IOContext mContext;
    final InputStream mIn;
    final byte[] mInputBuffer;
    private int mInputPtr;
    private int mInputEnd;
    private final boolean mBufferRecyclable;
    protected int mInputProcessed;
    boolean mBigEndian = true;
    int mBytesPerChar = 0;

    public ByteSourceBootstrapper(IOContext ctxt, InputStream in) {
        this.mContext = ctxt;
        this.mIn = in;
        this.mInputBuffer = ctxt.allocReadIOBuffer();
        this.mInputPtr = 0;
        this.mInputEnd = 0;
        this.mInputProcessed = 0;
        this.mBufferRecyclable = true;
    }

    public ByteSourceBootstrapper(IOContext ctxt, byte[] inputBuffer, int inputStart, int inputLen) {
        this.mContext = ctxt;
        this.mIn = null;
        this.mInputBuffer = inputBuffer;
        this.mInputPtr = inputStart;
        this.mInputEnd = inputStart + inputLen;
        this.mInputProcessed = -inputStart;
        this.mBufferRecyclable = false;
    }

    public JsonEncoding detectEncoding() throws IOException, JsonParseException {
        JsonEncoding enc;
        int i16;
        boolean foundEncoding = false;
        if (this.ensureLoaded(4)) {
            int quad = this.mInputBuffer[this.mInputPtr] << 24 | (this.mInputBuffer[this.mInputPtr + 1] & 0xFF) << 16 | (this.mInputBuffer[this.mInputPtr + 2] & 0xFF) << 8 | this.mInputBuffer[this.mInputPtr + 3] & 0xFF;
            if (this.handleBOM(quad)) {
                foundEncoding = true;
            } else if (this.checkUTF32(quad)) {
                foundEncoding = true;
            } else if (this.checkUTF16(quad >>> 16)) {
                foundEncoding = true;
            }
        } else if (this.ensureLoaded(2) && this.checkUTF16(i16 = (this.mInputBuffer[this.mInputPtr] & 0xFF) << 8 | this.mInputBuffer[this.mInputPtr + 1] & 0xFF)) {
            foundEncoding = true;
        }
        if (!foundEncoding) {
            enc = JsonEncoding.UTF8;
        } else if (this.mBytesPerChar == 2) {
            enc = this.mBigEndian ? JsonEncoding.UTF16_BE : JsonEncoding.UTF16_LE;
        } else if (this.mBytesPerChar == 4) {
            enc = this.mBigEndian ? JsonEncoding.UTF32_BE : JsonEncoding.UTF32_LE;
        } else {
            throw new RuntimeException("Internal error");
        }
        this.mContext.setEncoding(enc);
        return enc;
    }

    public Reader constructReader() throws IOException {
        JsonEncoding enc = this.mContext.getEncoding();
        switch (enc) {
            case UTF32_BE: 
            case UTF32_LE: {
                return new UTF32Reader(this.mContext, this.mIn, this.mInputBuffer, this.mInputPtr, this.mInputEnd, this.mContext.getEncoding().isBigEndian());
            }
            case UTF16_BE: 
            case UTF16_LE: {
                InputStream in = this.mIn;
                if (in == null) {
                    in = new ByteArrayInputStream(this.mInputBuffer, this.mInputPtr, this.mInputEnd);
                } else if (this.mInputPtr < this.mInputEnd) {
                    in = new MergedStream(this.mContext, in, this.mInputBuffer, this.mInputPtr, this.mInputEnd);
                }
                return new InputStreamReader(in, enc.getJavaName());
            }
            case UTF8: {
                return new UTF8Reader(this.mContext, this.mIn, this.mInputBuffer, this.mInputPtr, this.mInputEnd);
            }
        }
        throw new RuntimeException("Internal error");
    }

    public Utf8StreamParser createFastUtf8Parser(NameCanonicalizer nc) {
        return new Utf8StreamParser(this.mContext, this.mIn, nc, this.mInputBuffer, this.mInputPtr, this.mInputEnd, this.mBufferRecyclable);
    }

    private boolean handleBOM(int quad) throws IOException {
        switch (quad) {
            case 65279: {
                this.mBigEndian = true;
                this.mInputPtr += 4;
                this.mBytesPerChar = 4;
                return true;
            }
            case -131072: {
                this.mInputPtr += 4;
                this.mBytesPerChar = 4;
                this.mBigEndian = false;
                return true;
            }
            case 65534: {
                this.reportWeirdUCS4("2143");
            }
            case -16842752: {
                this.reportWeirdUCS4("3412");
            }
        }
        int msw = quad >>> 16;
        if (msw == 65279) {
            this.mInputPtr += 2;
            this.mBytesPerChar = 2;
            this.mBigEndian = true;
            return true;
        }
        if (msw == 65534) {
            this.mInputPtr += 2;
            this.mBytesPerChar = 2;
            this.mBigEndian = false;
            return true;
        }
        if (quad >>> 8 == 0xEFBBBF) {
            this.mInputPtr += 3;
            this.mBytesPerChar = 1;
            this.mBigEndian = true;
            return true;
        }
        return false;
    }

    private boolean checkUTF32(int quad) throws IOException {
        if (quad >> 8 == 0) {
            this.mBigEndian = true;
        } else if ((quad & 0xFFFFFF) == 0) {
            this.mBigEndian = false;
        } else if ((quad & 0xFF00FFFF) == 0) {
            this.reportWeirdUCS4("3412");
        } else if ((quad & 0xFFFF00FF) == 0) {
            this.reportWeirdUCS4("2143");
        } else {
            return false;
        }
        this.mBytesPerChar = 4;
        return true;
    }

    private boolean checkUTF16(int i16) {
        if ((i16 & 0xFF00) == 0) {
            this.mBigEndian = true;
        } else if ((i16 & 0xFF) == 0) {
            this.mBigEndian = false;
        } else {
            return false;
        }
        this.mBytesPerChar = 2;
        return true;
    }

    private void reportWeirdUCS4(String type) throws IOException {
        throw new CharConversionException("Unsupported UCS-4 endianness (" + type + ") detected");
    }

    protected boolean ensureLoaded(int minimum) throws IOException {
        int count;
        for (int gotten = this.mInputEnd - this.mInputPtr; gotten < minimum; gotten += count) {
            count = this.mIn == null ? -1 : this.mIn.read(this.mInputBuffer, this.mInputEnd, this.mInputBuffer.length - this.mInputEnd);
            if (count < 1) {
                return false;
            }
            this.mInputEnd += count;
        }
        return true;
    }
}

