/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson;

import org.codehaus.jackson.JsonWriteContext;

final class ObjectWContext
extends JsonWriteContext {
    protected String mCurrentName = null;
    protected boolean mExpectValue = false;

    public ObjectWContext(JsonWriteContext parent) {
        super(parent);
    }

    public JsonWriteContext.Type getType() {
        return JsonWriteContext.Type.OBJECT;
    }

    public String getCurrentName() {
        return this.mCurrentName;
    }

    public int writeFieldName(String name) {
        if (this.mCurrentName != null) {
            return 4;
        }
        this.mCurrentName = name;
        return this.mIndex < 0 ? 0 : 1;
    }

    public int writeValue() {
        if (this.mCurrentName == null) {
            return 5;
        }
        this.mCurrentName = null;
        ++this.mIndex;
        return 2;
    }

    public boolean inObject() {
        return true;
    }

    protected void appendDesc(StringBuilder sb) {
        sb.append('{');
        if (this.mCurrentName != null) {
            sb.append('\"');
            sb.append(this.mCurrentName);
            sb.append('\"');
        } else {
            sb.append('?');
        }
        sb.append(']');
    }
}

