/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.resolver;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import okhttp3.Authenticator;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.Route;
import okio.BufferedSink;
import org.codehaus.httpcache4j.HTTPHost;
import org.codehaus.httpcache4j.HTTPRequest;
import org.codehaus.httpcache4j.HTTPResponse;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.MIMEType;
import org.codehaus.httpcache4j.Status;
import org.codehaus.httpcache4j.StatusLine;
import org.codehaus.httpcache4j.payload.Payload;
import org.codehaus.httpcache4j.resolver.AbstractResponseResolver;
import org.codehaus.httpcache4j.resolver.ConnectionConfiguration;
import org.codehaus.httpcache4j.resolver.ResolverConfiguration;
import org.codehaus.httpcache4j.util.IOUtils;

public class OKHttpResponseResolver
extends AbstractResponseResolver {
    private final OkHttpClient client;

    public OKHttpResponseResolver(ResolverConfiguration config) {
        this(config, builder -> {});
    }

    public OKHttpResponseResolver(ResolverConfiguration configuration, Consumer<OkHttpClient.Builder> configF) {
        super(configuration);
        HTTPHost proxyHost;
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.authenticator((Authenticator)new NullAuthenticator());
        builder.followRedirects(false);
        builder.followSslRedirects(false);
        builder.cache(null);
        ConnectionConfiguration connConfig = configuration.getConnectionConfiguration();
        builder.connectionPool(new ConnectionPool(connConfig.getMaxConnections().orElse(new ConnectionPool().connectionCount()).intValue(), 300000L, TimeUnit.MILLISECONDS));
        connConfig.getConnectionRequestTimeout().ifPresent(i -> builder.readTimeout((long)i.intValue(), TimeUnit.MILLISECONDS));
        connConfig.getSocketTimeout().ifPresent(i -> builder.connectTimeout((long)i.intValue(), TimeUnit.MILLISECONDS));
        Dispatcher dispatcher = new Dispatcher();
        dispatcher.setMaxRequests(connConfig.getMaxConnections().orElse(dispatcher.getMaxRequests()).intValue());
        dispatcher.setMaxRequestsPerHost(connConfig.getDefaultConnectionsPerHost().orElse(dispatcher.getMaxRequestsPerHost()).intValue());
        builder.dispatcher(dispatcher);
        if (connConfig.getTimeout().isPresent()) {
            builder.connectTimeout((long)((Integer)connConfig.getTimeout().get()).intValue(), TimeUnit.MILLISECONDS);
        }
        if ((proxyHost = configuration.getProxyAuthenticator().getConfiguration().getHost()) != null) {
            builder.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost.getHost(), proxyHost.getPort())));
        }
        configF.accept(builder);
        this.client = builder.build();
    }

    protected HTTPResponse resolveImpl(HTTPRequest request) throws IOException {
        Request req = this.transformRequest(request);
        Response response = this.client.newCall(req).execute();
        return this.transformResponse(response);
    }

    private Request transformRequest(HTTPRequest request) {
        Request.Builder builder = new Request.Builder();
        builder.addHeader("User-Agent", this.getConfiguration().getUserAgent());
        Headers requestHeaders = request.getHeaders();
        for (Header header : requestHeaders) {
            builder.addHeader(header.getName(), header.getValue());
        }
        Optional<RequestBody> payload = request.getPayload().map(PayloadRequestBody::new);
        builder.method(request.getMethod().getMethod(), (RequestBody)payload.orElse(null));
        builder.url(HttpUrl.get((URI)request.getNormalizedURI()));
        return builder.build();
    }

    private HTTPResponse transformResponse(Response response) throws IOException {
        Status status = Status.valueOf((int)response.code());
        StatusLine line = new StatusLine(status, response.message());
        return new HTTPResponse(Optional.ofNullable(response.body()).map(PayloadResponseBody::new), line, new Headers(response.headers().toMultimap()));
    }

    public void shutdown() {
        this.client.dispatcher().executorService().shutdown();
    }

    public OkHttpClient getClient() {
        return this.client;
    }

    private static class NullAuthenticator
    implements Authenticator {
        private NullAuthenticator() {
        }

        public Request authenticate(Route route, Response response) throws IOException {
            return null;
        }
    }

    private static class PayloadResponseBody
    implements Payload {
        private final ResponseBody delegate;
        private boolean available;

        public PayloadResponseBody(ResponseBody payload) {
            this.delegate = payload;
        }

        public MIMEType getMimeType() {
            return MIMEType.valueOf((String)this.delegate.contentType().toString());
        }

        public InputStream getInputStream() {
            this.available = false;
            return this.delegate.byteStream();
        }

        public long length() {
            return this.delegate.contentLength();
        }

        public boolean isAvailable() {
            return this.available;
        }
    }

    private static class PayloadRequestBody
    extends RequestBody {
        private final Payload payload;

        public PayloadRequestBody(Payload payload) {
            this.payload = payload;
        }

        public MediaType contentType() {
            return MediaType.parse((String)this.payload.getMimeType().toString());
        }

        public void writeTo(BufferedSink bufferedSink) throws IOException {
            IOUtils.copy((InputStream)this.payload.getInputStream(), (OutputStream)bufferedSink.outputStream());
        }
    }
}

