/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.resolver;

import com.squareup.okhttp.Authenticator;
import com.squareup.okhttp.ConnectionPool;
import com.squareup.okhttp.Dispatcher;
import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import okio.BufferedSink;
import org.codehaus.httpcache4j.HTTPException;
import org.codehaus.httpcache4j.HTTPHost;
import org.codehaus.httpcache4j.HTTPRequest;
import org.codehaus.httpcache4j.HTTPResponse;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.MIMEType;
import org.codehaus.httpcache4j.Status;
import org.codehaus.httpcache4j.StatusLine;
import org.codehaus.httpcache4j.payload.Payload;
import org.codehaus.httpcache4j.resolver.AbstractResponseResolver;
import org.codehaus.httpcache4j.resolver.ConnectionConfiguration;
import org.codehaus.httpcache4j.resolver.ResolverConfiguration;
import org.codehaus.httpcache4j.util.IOUtils;

public class OKHttpResponseResolver
extends AbstractResponseResolver {
    private final OkHttpClient client = new OkHttpClient();

    protected OKHttpResponseResolver(ResolverConfiguration configuration) {
        super(configuration);
        HTTPHost proxyHost;
        this.client.setAuthenticator((Authenticator)new NullAuthenticator());
        this.client.setFollowRedirects(false);
        this.client.setFollowSslRedirects(false);
        this.client.setCache(null);
        ConnectionConfiguration connConfig = configuration.getConnectionConfiguration();
        this.client.setConnectionPool(new ConnectionPool(connConfig.getMaxConnections().orElse(ConnectionPool.getDefault().getConnectionCount()).intValue(), 300000L));
        connConfig.getConnectionRequestTimeout().ifPresent(i -> this.client.setReadTimeout((long)i.intValue(), TimeUnit.MILLISECONDS));
        connConfig.getSocketTimeout().ifPresent(i -> this.client.setConnectTimeout((long)i.intValue(), TimeUnit.MILLISECONDS));
        Dispatcher dispatcher = new Dispatcher();
        dispatcher.setMaxRequests(connConfig.getMaxConnections().orElse(dispatcher.getMaxRequests()).intValue());
        dispatcher.setMaxRequestsPerHost(connConfig.getDefaultConnectionsPerHost().orElse(dispatcher.getMaxRequestsPerHost()).intValue());
        this.client.setDispatcher(dispatcher);
        if (connConfig.getTimeout().isPresent()) {
            this.client.setConnectTimeout((long)((Integer)connConfig.getTimeout().get()).intValue(), TimeUnit.MILLISECONDS);
        }
        if ((proxyHost = configuration.getProxyAuthenticator().getConfiguration().getHost()) != null) {
            this.client.setProxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost.getHost(), proxyHost.getPort())));
        }
    }

    protected HTTPResponse resolveImpl(HTTPRequest request) throws IOException {
        Request req = this.transformRequest(request);
        Response response = this.client.newCall(req).execute();
        return this.transformResponse(response);
    }

    private Request transformRequest(HTTPRequest request) {
        Request.Builder builder = new Request.Builder();
        builder.addHeader("User-Agent", this.getConfiguration().getUserAgent());
        Headers requestHeaders = request.getHeaders();
        for (Header header : requestHeaders) {
            builder.addHeader(header.getName(), header.getValue());
        }
        Optional<RequestBody> payload = request.getPayload().map(PayloadRequestBody::new);
        builder.method(request.getMethod().getMethod(), (RequestBody)payload.orElse(null));
        builder.url(HttpUrl.get((URI)request.getNormalizedURI()));
        return builder.build();
    }

    private HTTPResponse transformResponse(Response response) throws IOException {
        Status status = Status.valueOf((int)response.code());
        StatusLine line = new StatusLine(status, response.message());
        return new HTTPResponse(Optional.ofNullable(response.body()).map(PayloadResponseBody::new), line, new Headers(response.headers().toMultimap()));
    }

    public void shutdown() {
        this.client.getDispatcher().getExecutorService().shutdown();
    }

    public OkHttpClient getClient() {
        return this.client;
    }

    private static class NullAuthenticator
    implements Authenticator {
        private NullAuthenticator() {
        }

        public Request authenticate(Proxy proxy, Response response) throws IOException {
            return null;
        }

        public Request authenticateProxy(Proxy proxy, Response response) throws IOException {
            return null;
        }
    }

    private static class PayloadResponseBody
    implements Payload {
        private final ResponseBody delegate;
        private boolean available;

        public PayloadResponseBody(ResponseBody payload) {
            this.delegate = payload;
        }

        public MIMEType getMimeType() {
            return MIMEType.valueOf((String)this.delegate.contentType().toString());
        }

        public InputStream getInputStream() {
            try {
                this.available = false;
                return this.delegate.byteStream();
            }
            catch (IOException e) {
                throw new HTTPException((Throwable)e);
            }
        }

        public long length() {
            try {
                return this.delegate.contentLength();
            }
            catch (IOException e) {
                throw new HTTPException((Throwable)e);
            }
        }

        public boolean isAvailable() {
            return this.available;
        }
    }

    private static class PayloadRequestBody
    extends RequestBody {
        private final Payload payload;

        public PayloadRequestBody(Payload payload) {
            this.payload = payload;
        }

        public MediaType contentType() {
            return MediaType.parse((String)this.payload.getMimeType().toString());
        }

        public void writeTo(BufferedSink bufferedSink) throws IOException {
            IOUtils.copy((InputStream)this.payload.getInputStream(), (OutputStream)bufferedSink.outputStream());
        }
    }
}

