/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.resolver.ning;

import io.netty.handler.codec.http.HttpHeaders;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Response;
import org.asynchttpclient.request.body.generator.BodyGenerator;
import org.asynchttpclient.request.body.generator.InputStreamBodyGenerator;
import org.codehaus.httpcache4j.HTTPException;
import org.codehaus.httpcache4j.HTTPMethod;
import org.codehaus.httpcache4j.HTTPRequest;
import org.codehaus.httpcache4j.HTTPResponse;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.Status;
import org.codehaus.httpcache4j.StatusLine;
import org.codehaus.httpcache4j.auth.Authenticator;
import org.codehaus.httpcache4j.auth.ProxyAuthenticator;
import org.codehaus.httpcache4j.resolver.AbstractResponseResolver;
import org.codehaus.httpcache4j.resolver.ConnectionConfiguration;
import org.codehaus.httpcache4j.resolver.ResolverConfiguration;
import org.codehaus.httpcache4j.resolver.ResponseCreator;

public class NingResponseResolver
extends AbstractResponseResolver {
    private final AsyncHttpClient client;

    protected NingResponseResolver(ResolverConfiguration configuration, DefaultAsyncHttpClientConfig.Builder builder, Consumer<DefaultAsyncHttpClientConfig.Builder> configF) {
        super(configuration);
        builder.setUserAgent(configuration.getUserAgent());
        builder.setFollowRedirect(false);
        ConnectionConfiguration connectionConfiguration = this.configureConnections(configuration, builder);
        configF.accept(builder);
        if (!connectionConfiguration.getConnectionsPerHost().isEmpty()) {
            throw new UnsupportedOperationException("This Resolver does not support connections per host");
        }
        this.client = new DefaultAsyncHttpClient((AsyncHttpClientConfig)builder.build());
    }

    private ConnectionConfiguration configureConnections(ResolverConfiguration configuration, DefaultAsyncHttpClientConfig.Builder config) {
        ConnectionConfiguration connectionConfiguration = configuration.getConnectionConfiguration();
        if (connectionConfiguration.getMaxConnections().isPresent()) {
            config.setMaxConnections(((Integer)connectionConfiguration.getMaxConnections().get()).intValue());
        }
        if (connectionConfiguration.getDefaultConnectionsPerHost().isPresent()) {
            config.setMaxConnectionsPerHost(((Integer)connectionConfiguration.getDefaultConnectionsPerHost().get()).intValue());
        }
        if (connectionConfiguration.getTimeout().isPresent()) {
            config.setReadTimeout(((Integer)connectionConfiguration.getTimeout().get()).intValue());
        }
        if (connectionConfiguration.getSocketTimeout().isPresent()) {
            config.setConnectTimeout(((Integer)connectionConfiguration.getSocketTimeout().get()).intValue());
        }
        return connectionConfiguration;
    }

    public NingResponseResolver(ResolverConfiguration configuration) {
        this(configuration, new DefaultAsyncHttpClientConfig.Builder(), config -> {});
    }

    public NingResponseResolver(ResolverConfiguration configuration, Consumer<DefaultAsyncHttpClientConfig.Builder> configF) {
        this(configuration, new DefaultAsyncHttpClientConfig.Builder(), configF);
    }

    public NingResponseResolver(ProxyAuthenticator proxyAuthenticator, Authenticator authenticator) {
        this(new ResolverConfiguration(proxyAuthenticator, authenticator, new ConnectionConfiguration()));
    }

    public static NingResponseResolver newInstance(ResolverConfiguration configuration) {
        return new NingResponseResolver(configuration);
    }

    public static NingResponseResolver newInstance(ConnectionConfiguration configuration) {
        return NingResponseResolver.newInstance(new ResolverConfiguration().withConnectionConfiguration(configuration));
    }

    public static NingResponseResolver newInstance() {
        return NingResponseResolver.newInstance(new ConnectionConfiguration());
    }

    protected HTTPResponse resolveImpl(HTTPRequest request) throws IOException {
        Future<Response> responseFuture = this.execute(request);
        return this.translate(responseFuture);
    }

    public void shutdown() {
        try {
            this.client.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private HTTPResponse translate(Future<Response> responseFuture) throws IOException {
        try {
            Response response = responseFuture.get();
            StatusLine line = new StatusLine(Status.valueOf((int)response.getStatusCode()), response.getStatusText());
            HttpHeaders headers = response.getHeaders();
            Optional<InputStream> stream = Optional.ofNullable(response.getResponseBodyAsStream());
            List headerList = StreamSupport.stream(headers.spliterator(), false).map(e -> new Header((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
            return ResponseCreator.createResponse((StatusLine)line, (Headers)new Headers(headerList), stream);
        }
        catch (InterruptedException e2) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e3) {
            throw new HTTPException(e3.getCause());
        }
        throw new HTTPException("Not possible to get response");
    }

    private Future<Response> execute(HTTPRequest request) throws IOException {
        BoundRequestBuilder builder = this.builder(request.getNormalizedURI(), request.getMethod());
        if (request.getMethod().canHavePayload()) {
            request.getPayload().ifPresent(p -> {
                if (this.getConfiguration().isUseChunked()) {
                    builder.setBody((BodyGenerator)new InputStreamBodyGenerator(p.getInputStream()));
                } else {
                    builder.setBody(p.getInputStream());
                }
            });
        }
        for (Header header : request.getAllHeaders()) {
            builder.addHeader((CharSequence)header.getName(), header.getValue());
        }
        return builder.execute();
    }

    private BoundRequestBuilder builder(URI uri, HTTPMethod method) {
        if (HTTPMethod.DELETE.equals((Object)method)) {
            return this.client.prepareDelete(uri.toString());
        }
        if (HTTPMethod.GET.equals((Object)method)) {
            return this.client.prepareGet(uri.toString());
        }
        if (HTTPMethod.HEAD.equals((Object)method)) {
            return this.client.prepareHead(uri.toString());
        }
        if (HTTPMethod.OPTIONS.equals((Object)method)) {
            return this.client.prepareOptions(uri.toString());
        }
        if (HTTPMethod.POST.equals((Object)method)) {
            return this.client.preparePost(uri.toString());
        }
        if (HTTPMethod.PUT.equals((Object)method)) {
            return this.client.preparePut(uri.toString());
        }
        throw new IllegalArgumentException("Unable to create request for method " + method);
    }
}

