/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.resolver;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.codehaus.httpcache4j.HTTPException;
import org.codehaus.httpcache4j.HTTPMethod;
import org.codehaus.httpcache4j.HTTPRequest;
import org.codehaus.httpcache4j.HTTPResponse;
import org.codehaus.httpcache4j.HTTPVersion;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.Status;
import org.codehaus.httpcache4j.StatusLine;
import org.codehaus.httpcache4j.auth.Authenticator;
import org.codehaus.httpcache4j.auth.DefaultAuthenticator;
import org.codehaus.httpcache4j.auth.DefaultProxyAuthenticator;
import org.codehaus.httpcache4j.auth.ProxyAuthenticator;
import org.codehaus.httpcache4j.auth.ProxyConfiguration;
import org.codehaus.httpcache4j.payload.DelegatingInputStream;
import org.codehaus.httpcache4j.payload.Payload;
import org.codehaus.httpcache4j.resolver.AbstractResponseResolver;
import org.codehaus.httpcache4j.resolver.ConnectionConfiguration;
import org.codehaus.httpcache4j.resolver.HttpClientFactory;
import org.codehaus.httpcache4j.resolver.ResolverConfiguration;
import org.codehaus.httpcache4j.resolver.ResponseCreator;

public class HTTPClientResponseResolver
extends AbstractResponseResolver {
    private final CloseableHttpClient httpClient;

    public HTTPClientResponseResolver(CloseableHttpClient httpClient, ResolverConfiguration configuration) {
        super(configuration);
        this.httpClient = httpClient;
    }

    public HTTPClientResponseResolver(CloseableHttpClient httpClient, ProxyAuthenticator proxyAuthenticator, Authenticator authenticator) {
        this(httpClient, new ResolverConfiguration(proxyAuthenticator, authenticator, new ConnectionConfiguration()));
    }

    public HTTPClientResponseResolver(CloseableHttpClient httpClient, ProxyConfiguration proxyConfiguration) {
        this(httpClient, (ProxyAuthenticator)new DefaultProxyAuthenticator(proxyConfiguration), (Authenticator)new DefaultAuthenticator());
    }

    public HTTPClientResponseResolver(CloseableHttpClient httpClient) {
        this(httpClient, new ProxyConfiguration());
    }

    public static HTTPClientResponseResolver createMultithreadedInstance(ConnectionConfiguration config) {
        return HTTPClientResponseResolver.createMultithreadedInstance(new ResolverConfiguration().withConnectionConfiguration(config));
    }

    public static HTTPClientResponseResolver createMultithreadedInstance() {
        return HTTPClientResponseResolver.createMultithreadedInstance(new ConnectionConfiguration());
    }

    public static HTTPClientResponseResolver createMultithreadedInstance(ResolverConfiguration configuration) {
        HttpClientBuilder builder = HttpClientBuilder.create();
        CloseableHttpClient client = new HttpClientFactory().configure(builder, configuration);
        return new HTTPClientResponseResolver(client, configuration);
    }

    public final CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    protected HTTPResponse resolveImpl(HTTPRequest request) throws IOException {
        HttpUriRequest realRequest = this.convertRequest(request);
        CloseableHttpResponse response = this.httpClient.execute(realRequest);
        return this.convertResponse(realRequest, (HttpResponse)response);
    }

    @Deprecated
    public void setRedirecting(boolean redirect) {
        throw new UnsupportedOperationException("You need to set this when creating the HttpClient, sorry!");
    }

    public void shutdown() {
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (IOException e) {
                throw new HTTPException((Throwable)e);
            }
        }
    }

    private HttpUriRequest convertRequest(HTTPRequest request) {
        HttpUriRequest realRequest = this.getMethod(request.getMethod(), request.getNormalizedURI());
        Headers headers = request.getAllHeaders();
        for (Header header : headers) {
            realRequest.addHeader(header.getName(), header.getValue());
        }
        if (request.hasPayload() && realRequest instanceof HttpEntityEnclosingRequest) {
            HttpEntityEnclosingRequest req = (HttpEntityEnclosingRequest)realRequest;
            req.setEntity((HttpEntity)new PayloadEntity(request.getPayload(), this.getConfiguration().isUseChunked()));
        }
        return realRequest;
    }

    protected HttpUriRequest getMethod(HTTPMethod method, URI requestURI) {
        if (method.canHavePayload()) {
            return new MethodWithBody(requestURI, method);
        }
        return new Method(requestURI, method);
    }

    private HTTPResponse convertResponse(HttpUriRequest request, HttpResponse response) throws IOException {
        org.apache.http.Header[] realHeaders;
        Headers headers = new Headers();
        for (org.apache.http.Header header : realHeaders = response.getAllHeaders()) {
            headers = headers.add(header.getName(), header.getValue());
        }
        InputStream stream = this.getStream(request, response);
        ProtocolVersion protocolversion = response.getStatusLine().getProtocolVersion();
        StatusLine line = new StatusLine(HTTPVersion.get((String)(protocolversion.getMajor() + "." + protocolversion.getMinor())), Status.valueOf((int)response.getStatusLine().getStatusCode()), response.getStatusLine().getReasonPhrase());
        return ResponseCreator.createResponse((StatusLine)line, (Headers)headers, (InputStream)stream);
    }

    private InputStream getStream(HttpUriRequest realRequest, HttpResponse response) throws IOException {
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            return null;
        }
        try {
            return new HttpEntityInputStream(entity);
        }
        catch (IOException e) {
            realRequest.abort();
            throw e;
        }
        catch (RuntimeException e) {
            realRequest.abort();
            throw e;
        }
    }

    @NotThreadSafe
    private static class MethodWithBody
    extends HttpEntityEnclosingRequestBase {
        private HTTPMethod method;

        public MethodWithBody(URI uri, HTTPMethod method) {
            this.method = method;
            this.setURI(uri);
        }

        public String getMethod() {
            return this.method.getMethod();
        }
    }

    @NotThreadSafe
    private static class Method
    extends HttpRequestBase {
        private HTTPMethod method;

        public Method(URI uri, HTTPMethod method) {
            this.method = method;
            this.setURI(uri);
        }

        public String getMethod() {
            return this.method.getMethod();
        }
    }

    private static class PayloadEntity
    extends InputStreamEntity {
        public PayloadEntity(Payload payload, boolean chunked) {
            super(payload.getInputStream(), chunked ? -1L : payload.length());
            this.setContentType(payload.getMimeType().toString());
            this.setChunked(chunked);
        }
    }

    private static class HttpEntityInputStream
    extends DelegatingInputStream {
        private final HttpEntity entity;

        public HttpEntityInputStream(HttpEntity entity) throws IOException {
            super(entity.getContent());
            this.entity = entity;
        }

        public void close() throws IOException {
            EntityUtils.consume((HttpEntity)this.entity);
        }
    }
}

