/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.resolver;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.codehaus.httpcache4j.HTTPHost;
import org.codehaus.httpcache4j.HTTPMethod;
import org.codehaus.httpcache4j.HTTPRequest;
import org.codehaus.httpcache4j.HTTPResponse;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.Status;
import org.codehaus.httpcache4j.auth.Authenticator;
import org.codehaus.httpcache4j.auth.DefaultAuthenticator;
import org.codehaus.httpcache4j.auth.DefaultProxyAuthenticator;
import org.codehaus.httpcache4j.auth.ProxyAuthenticator;
import org.codehaus.httpcache4j.auth.ProxyConfiguration;
import org.codehaus.httpcache4j.payload.DelegatingInputStream;
import org.codehaus.httpcache4j.resolver.AbstractResponseResolver;

public class HTTPClientResponseResolver
extends AbstractResponseResolver {
    private HttpClient httpClient;

    public HTTPClientResponseResolver(HttpClient httpClient, ProxyAuthenticator proxyAuthenticator, Authenticator authenticator) {
        super(proxyAuthenticator, authenticator);
        this.httpClient = httpClient;
        HTTPHost proxyHost = proxyAuthenticator.getConfiguration().getHost();
        if (proxyHost != null) {
            HttpHost host = new HttpHost(proxyHost.getHost(), proxyHost.getPort(), proxyHost.getScheme());
            httpClient.getParams().setParameter("http.route.default-proxy", (Object)host);
        }
    }

    public HTTPClientResponseResolver(HttpClient httpClient, ProxyConfiguration proxyConfiguration) {
        this(httpClient, (ProxyAuthenticator)new DefaultProxyAuthenticator(proxyConfiguration), (Authenticator)new DefaultAuthenticator());
    }

    public HTTPClientResponseResolver(HttpClient httpClient) {
        this(httpClient, new ProxyConfiguration());
    }

    public static HTTPClientResponseResolver createMultithreadedInstance() {
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        schemeRegistry.register(new Scheme("https", (SocketFactory)SSLSocketFactory.getSocketFactory(), 443));
        ThreadSafeClientConnManager cm = new ThreadSafeClientConnManager((HttpParams)new BasicHttpParams(), schemeRegistry);
        return new HTTPClientResponseResolver((HttpClient)new DefaultHttpClient((ClientConnectionManager)cm, (HttpParams)new BasicHttpParams()));
    }

    public HTTPResponse resolve(HTTPRequest request) throws IOException {
        HttpResponse response;
        HttpUriRequest realRequest;
        HTTPResponse convertedResponse;
        HTTPRequest req = request;
        if (this.isPreemptiveAuthenticationEnabled()) {
            req = this.getAuthenticator().preparePreemptiveAuthentication(request);
            req = this.getProxyAuthenticator().preparePreemptiveAuthentication(req);
        }
        if ((convertedResponse = this.convertResponse(realRequest = this.convertRequest(req), response = this.httpClient.execute(realRequest))).getStatus() == Status.PROXY_AUTHENTICATION_REQUIRED && (req = this.getProxyAuthenticator().prepareAuthentication(req, convertedResponse)) != request) {
            convertedResponse.consume();
            realRequest = this.convertRequest(req);
            response = this.httpClient.execute(realRequest);
            convertedResponse = this.convertResponse(realRequest, response);
            if (convertedResponse.getStatus() == Status.PROXY_AUTHENTICATION_REQUIRED) {
                this.getProxyAuthenticator().afterFailedAuthentication(convertedResponse.getHeaders());
                this.disablePreemtiveAuthentication();
            } else {
                this.getProxyAuthenticator().afterSuccessfulAuthentication(convertedResponse.getHeaders());
                this.enablePreemptiveAuthentication();
            }
        }
        if (convertedResponse.getStatus() == Status.UNAUTHORIZED && (req = this.getAuthenticator().prepareAuthentication(req, convertedResponse)) != request) {
            convertedResponse.consume();
            realRequest = this.convertRequest(req);
            response = this.httpClient.execute(realRequest);
            convertedResponse = this.convertResponse(realRequest, response);
            if (convertedResponse.getStatus() == Status.UNAUTHORIZED) {
                this.getAuthenticator().afterFailedAuthentication(req, convertedResponse.getHeaders());
                this.disablePreemtiveAuthentication();
            } else {
                this.getAuthenticator().afterSuccessfulAuthentication(req, convertedResponse.getHeaders());
                this.enablePreemptiveAuthentication();
            }
        }
        return convertedResponse;
    }

    private HttpUriRequest convertRequest(HTTPRequest request) {
        HttpUriRequest realRequest = this.getMethod(request.getMethod(), request.getRequestURI());
        Headers headers = request.getAllHeaders();
        for (Header header : headers) {
            realRequest.addHeader(header.getName(), header.getValue());
        }
        if (request.hasPayload() && realRequest instanceof HttpEntityEnclosingRequest) {
            HttpEntityEnclosingRequest req = (HttpEntityEnclosingRequest)realRequest;
            InputStreamEntity e = new InputStreamEntity(request.getPayload().getInputStream(), -1L){

                public void writeTo(OutputStream outstream) throws IOException {
                    IOUtils.copy((InputStream)this.getContent(), (OutputStream)outstream);
                }
            };
            e.setContentType(request.getPayload().getMimeType().toString());
            req.setEntity((HttpEntity)e);
        }
        return realRequest;
    }

    HttpUriRequest getMethod(HTTPMethod method, URI requestURI) {
        switch (method) {
            case GET: {
                return new HttpGet(requestURI);
            }
            case HEAD: {
                return new HttpHead(requestURI);
            }
            case OPTIONS: {
                return new HttpOptions(requestURI);
            }
            case TRACE: {
                return new HttpTrace(requestURI);
            }
            case PUT: {
                return new HttpPut(requestURI);
            }
            case POST: {
                return new HttpPost(requestURI);
            }
            case DELETE: {
                return new HttpDelete(requestURI);
            }
        }
        throw new IllegalArgumentException("Uknown method");
    }

    private HTTPResponse convertResponse(HttpUriRequest request, HttpResponse response) throws IOException {
        org.apache.http.Header[] realHeaders;
        Status status = Status.valueOf((int)response.getStatusLine().getStatusCode());
        Headers headers = new Headers();
        for (org.apache.http.Header header : realHeaders = response.getAllHeaders()) {
            headers = headers.add(header.getName(), header.getValue());
        }
        InputStream stream = this.getStream(request, response);
        return this.getResponseCreator().createResponse(status, headers, stream);
    }

    private InputStream getStream(HttpUriRequest realRequest, HttpResponse response) throws IOException {
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            return null;
        }
        try {
            return new HttpEntityInputStream(entity);
        }
        catch (IOException e) {
            realRequest.abort();
            throw e;
        }
        catch (RuntimeException e) {
            realRequest.abort();
            throw e;
        }
    }

    private static class HttpEntityInputStream
    extends DelegatingInputStream {
        private final HttpEntity entity;

        public HttpEntityInputStream(HttpEntity entity) throws IOException {
            super(entity.getContent());
            this.entity = entity;
        }

        public void close() throws IOException {
            this.entity.consumeContent();
        }
    }
}

