/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.cache;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.codehaus.httpcache4j.Challenge;
import org.codehaus.httpcache4j.HTTPRequest;
import org.codehaus.httpcache4j.HTTPResponse;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.cache.Vary;
import org.codehaus.httpcache4j.uri.URIBuilder;

public final class Key
implements Serializable {
    private static final long serialVersionUID = 5827064595759738979L;
    private URI uri;
    private Vary vary;

    public static Key create(URI uri, Vary vary) {
        return new Key(URIBuilder.fromURI((URI)Objects.requireNonNull(uri, "URI may not be null")).toNormalizedURI(), Objects.requireNonNull(vary, "vary may not be null"));
    }

    public static Key create(HTTPRequest request, HTTPResponse response) {
        URI uri = request.getNormalizedURI();
        return new Key(uri, Key.determineVariation(response.getHeaders(), request));
    }

    private static Vary determineVariation(Headers responseHeaders, HTTPRequest request) {
        Headers requestHeaders = request.getAllHeaders();
        Optional varyHeader = responseHeaders.getFirstHeaderValue("Vary");
        HashMap<String, String> resolvedVaryHeaders = new HashMap<String, String>();
        if (varyHeader.isPresent()) {
            String[] varies;
            String varyValue = (String)varyHeader.get();
            if (varyValue.equals("*")) {
                return Vary.ALL;
            }
            for (String vary : varies = varyValue.split(",")) {
                Optional value = requestHeaders.getFirstHeaderValue(vary);
                value.ifPresent(s -> resolvedVaryHeaders.put(vary, (String)s));
            }
        }
        if (request.getChallenge().isPresent() && Boolean.getBoolean("Vary.authorization")) {
            resolvedVaryHeaders.put("Authorization", ((Challenge)request.getChallenge().get()).getIdentifier());
        }
        return new Vary(resolvedVaryHeaders);
    }

    Key(URI uri, Vary vary) {
        Objects.requireNonNull(uri, "URI may not be null");
        Objects.requireNonNull(vary, "Vary may not be null");
        this.uri = uri;
        this.vary = vary;
    }

    public URI getURI() {
        return this.uri;
    }

    public Vary getVary() {
        return this.vary;
    }

    public String toString() {
        return this.toProperties().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Key key = (Key)o;
        if (this.uri != null ? !this.uri.equals(key.uri) : key.uri != null) {
            return false;
        }
        return !(this.vary != null ? !this.vary.equals(key.vary) : key.vary != null);
    }

    public int hashCode() {
        int result = this.uri != null ? this.uri.hashCode() : 0;
        result = 31 * result + (this.vary != null ? this.vary.hashCode() : 0);
        return result;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.toProperties());
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        Properties properties = (Properties)in.readObject();
        Key key = Key.parse(properties);
        this.uri = key.getURI();
        this.vary = key.getVary();
    }

    public static Key parse(Properties properties) {
        URI uri = null;
        Vary vary = null;
        if (properties.containsKey("uri")) {
            uri = URIBuilder.fromURI((URI)URI.create(properties.getProperty("uri"))).toNormalizedURI();
        }
        if (properties.containsKey("vary")) {
            vary = Vary.parse(properties.getProperty("vary"));
        }
        return new Key(uri, vary);
    }

    public Properties toProperties() {
        Properties object = new Properties();
        object.put("uri", this.uri.toString());
        object.put("vary", this.vary.toString());
        return object;
    }
}

