/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.cache;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.codehaus.httpcache4j.cache.Key;
import org.codehaus.httpcache4j.util.DeletingFileVisitor;
import org.codehaus.httpcache4j.util.Digester;
import org.codehaus.httpcache4j.util.IOUtils;

public final class FileManager
implements Serializable {
    private static final long serialVersionUID = -5273056780013227862L;
    private final File baseDirectory;

    public FileManager(File baseDirectory) {
        Objects.requireNonNull(baseDirectory, "Base directory may not be null");
        this.baseDirectory = this.createFilesDirectory(baseDirectory);
    }

    public File getBaseDirectory() {
        return this.baseDirectory;
    }

    public synchronized File createFile(Key key, InputStream stream) throws IOException {
        File file = this.resolve(key);
        if (!file.getParentFile().exists()) {
            this.ensureDirectoryExists(file.getParentFile());
        }
        try (InputStream is = stream;
             OutputStream to = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            IOUtils.copy((InputStream)is, (OutputStream)to);
        }
        if (file.length() == 0L) {
            file.delete();
            file = null;
        }
        if (file != null && !file.exists()) {
            throw new IOException(String.format("Failed to create File '%s' for Key: %s", file.getName(), key));
        }
        return file;
    }

    public synchronized File moveFile(File fromFile, Key to) throws IOException {
        File toFile = this.resolve(to);
        if (!toFile.getParentFile().exists()) {
            this.ensureDirectoryExists(toFile.getParentFile());
        }
        Files.move(fromFile.toPath(), toFile.toPath(), new CopyOption[0]);
        if (toFile.length() == 0L) {
            toFile.delete();
            toFile = null;
        }
        if (toFile != null && !toFile.exists()) {
            throw new IOException(String.format("Failed to move File '%s' to File %s for Key: %s", fromFile.getName(), toFile.getName(), to));
        }
        return toFile;
    }

    public synchronized void clear() {
        this.deleteDirectory(this.baseDirectory);
    }

    public synchronized void remove(Key key) {
        File resolved = this.resolve(key);
        if (resolved.delete() && this.directoryIsEmpty(resolved.getParentFile())) {
            try {
                Files.deleteIfExists(resolved.getParentFile().toPath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public synchronized void clear(URI uri) {
        File resolved = this.resolve(uri);
        this.deleteDirectory(resolved);
        if (this.directoryIsEmpty(resolved.getParentFile())) {
            try {
                Files.deleteIfExists(resolved.getParentFile().toPath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void deleteDirectory(File resolved) {
        if (Files.isDirectory(resolved.toPath(), new LinkOption[0])) {
            try {
                Files.walkFileTree(resolved.toPath(), new DeletingFileVisitor());
                Files.deleteIfExists(resolved.toPath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public synchronized void ensureDirectoryExists(File directory) {
        try {
            Files.createDirectories(directory.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized File resolve(Key key) {
        File uriFolder = this.resolve(key.getURI());
        String vary = key.getVary().isEmpty() ? "default" : Digester.md5((String)key.getVary().toString(), (Charset)StandardCharsets.UTF_8);
        return new File(uriFolder, vary);
    }

    public synchronized File resolve(URI uri) {
        String uriHex = Digester.md5((String)uri.toString(), (Charset)StandardCharsets.UTF_8);
        String distribution = uriHex.substring(0, 2);
        return new File(new File(this.baseDirectory, distribution), uriHex);
    }

    private boolean directoryIsEmpty(File directory) {
        try {
            return !Files.list(directory.toPath()).findAny().isPresent();
        }
        catch (IOException e) {
            return false;
        }
    }

    private File createFilesDirectory(File baseDirectory) {
        File files = new File(baseDirectory, "files");
        this.ensureDirectoryExists(files);
        return files;
    }
}

