/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.cache;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.temporal.Temporal;
import java.util.Objects;
import java.util.Optional;
import org.codehaus.httpcache4j.CacheControl;
import org.codehaus.httpcache4j.HTTPResponse;
import org.codehaus.httpcache4j.cache.CacheItem;
import org.codehaus.httpcache4j.payload.Payload;
import org.codehaus.httpcache4j.util.OptionalUtils;

public class DefaultCacheItem
implements CacheItem {
    protected LocalDateTime cachedTime;
    protected HTTPResponse response;
    protected long ttl;

    public DefaultCacheItem(HTTPResponse response) {
        this(response, LocalDateTime.now());
    }

    public DefaultCacheItem(HTTPResponse response, LocalDateTime cachedTime) {
        this.response = Objects.requireNonNull(response, "Response may not be null");
        this.cachedTime = Objects.requireNonNull(cachedTime, "CacheTime may not be null");
        this.ttl = DefaultCacheItem.getTTL(response, 0);
    }

    @Override
    public long getTTL() {
        return this.ttl;
    }

    @Override
    public boolean isStale(LocalDateTime requestTime) {
        if (this.response.hasPayload() && !((Payload)this.response.getPayload().get()).isAvailable()) {
            return true;
        }
        return this.ttl - this.getAge(requestTime) <= 0L;
    }

    @Override
    public long getAge(LocalDateTime requestTime) {
        return Duration.between(this.cachedTime, requestTime).getSeconds();
    }

    public static long getTTL(HTTPResponse response, int defaultTTLinSeconds) {
        int maxAge;
        Optional cc = response.getHeaders().getCacheControl();
        if (cc.isPresent() && (maxAge = ((CacheControl)cc.get()).getMaxAge()) > 0) {
            return maxAge;
        }
        Optional expires = response.getHeaders().getExpires();
        if (expires.isPresent()) {
            LocalDateTime expiryDate = (LocalDateTime)expires.get();
            Optional date = response.getHeaders().getDate();
            if (OptionalUtils.exists((Optional)date, dt -> dt.isBefore(expiryDate))) {
                return Duration.between((Temporal)date.get(), expiryDate).getSeconds();
            }
        }
        return defaultTTLinSeconds;
    }

    @Override
    public LocalDateTime getCachedTime() {
        return this.cachedTime;
    }

    @Override
    public HTTPResponse getResponse() {
        return this.response;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultCacheItem cacheItem = (DefaultCacheItem)o;
        if (this.cachedTime != null ? !this.cachedTime.equals(cacheItem.cachedTime) : cacheItem.cachedTime != null) {
            return false;
        }
        return !(this.response != null ? !this.response.equals((Object)cacheItem.response) : cacheItem.response != null);
    }

    public int hashCode() {
        int result = this.cachedTime != null ? this.cachedTime.hashCode() : 0;
        result = 31 * result + (this.response != null ? this.response.hashCode() : 0);
        return result;
    }
}

