/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.cache;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.Validate;
import org.codehaus.httpcache4j.cache.CacheItem;
import org.codehaus.httpcache4j.cache.Vary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheValue
implements Iterable<Map.Entry<Vary, CacheItem>>,
Serializable {
    private final Map<Vary, CacheItem> variations = new ConcurrentHashMap<Vary, CacheItem>();
    private static final long serialVersionUID = 1589764737954233106L;

    public CacheValue(Map<Vary, CacheItem> pVariations) {
        Validate.notNull(pVariations, (String)"Variations may not be null");
        this.variations.putAll(pVariations);
    }

    @Override
    public Iterator<Map.Entry<Vary, CacheItem>> iterator() {
        return Collections.unmodifiableMap(this.variations).entrySet().iterator();
    }

    public void remove(Vary vary) {
        this.variations.remove(vary);
    }

    public boolean isEmpty() {
        return this.variations.isEmpty();
    }

    public void add(Vary vary, CacheItem cacheItem) {
        this.variations.put(vary, cacheItem);
    }

    public int size() {
        return this.variations.size();
    }
}

