/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.preference;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.codehaus.httpcache4j.Directive;
import org.codehaus.httpcache4j.Directives;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.util.NumberUtils;
import org.codehaus.httpcache4j.util.Preconditions;

public final class Preference {
    private final String preference;
    private final double quality;

    public Preference(String preference) {
        this(preference, 1.0);
    }

    public Preference(String preference, double quality) {
        Preconditions.checkArgument(quality <= 1.0 && quality > 0.0, "Quality is a percentage ranging from 0.0, to 1.0");
        this.preference = Objects.requireNonNull(preference, "Preference may not be null, use a ALL preference instead.");
        this.quality = quality;
    }

    public String getPreference() {
        return this.preference;
    }

    public double getQuality() {
        return this.quality;
    }

    public String toString() {
        StringBuilder headerValue = new StringBuilder();
        if (this.getQuality() != 1.0) {
            headerValue.append(this.preference).append(";q=").append(this.getQuality());
        } else {
            headerValue.append(this.preference);
        }
        return headerValue.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Preference that = (Preference)o;
        return !(this.preference != null ? !this.preference.equals(that.preference) : that.preference != null);
    }

    public int hashCode() {
        return this.preference != null ? this.preference.hashCode() : 0;
    }

    public static List<Preference> wrap(String ... values) {
        return Collections.unmodifiableList(Arrays.asList(values).stream().map(Preference::new).collect(Collectors.toList()));
    }

    public static Header toHeader(String headerName, List<Preference> preferences) {
        ArrayList<Preference> pref = new ArrayList<Preference>(preferences);
        Collections.sort(pref, new PreferenceComparator());
        StringBuilder builder = new StringBuilder();
        for (Preference preference : pref) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(preference.getPreference());
            if (preference.getQuality() == 1.0) continue;
            builder.append(";q=").append(preference.getQuality());
        }
        return new Header(headerName, builder.toString());
    }

    public static List<Preference> parse(Header header) {
        return Preference.parse(Optional.ofNullable(header));
    }

    public static List<Preference> parse(Optional<Header> header) {
        ArrayList<Preference> accept = new ArrayList<Preference>();
        Optional<Directives> dir = header.map(Header::getDirectives);
        Directives directives = dir.orElse(new Directives());
        for (Directive directive : directives) {
            String value = directive.getName();
            double quality = NumberUtils.toDouble(directive.getParameterValue("q"), 1.0);
            accept.add(new Preference(value, quality));
        }
        Collections.sort(accept, new PreferenceComparator());
        return Collections.unmodifiableList(accept);
    }

    public static class PreferenceComparator
    implements Comparator<Preference> {
        @Override
        public int compare(Preference o1, Preference o2) {
            return Double.compare(o2.getQuality(), o1.getQuality());
        }
    }
}

