/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.auth.bearer;

import org.codehaus.httpcache4j.Challenge;
import org.codehaus.httpcache4j.HTTPRequest;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.auth.AuthScheme;
import org.codehaus.httpcache4j.auth.AuthenticatorStrategy;
import org.codehaus.httpcache4j.auth.bearer.BearerTokenChallenge;

public final class BearerAuthenticatorStrategy
implements AuthenticatorStrategy {
    @Override
    public boolean supports(AuthScheme scheme) {
        return "Bearer".equalsIgnoreCase(scheme.getType());
    }

    @Override
    public HTTPRequest prepare(HTTPRequest request, AuthScheme scheme) {
        HTTPRequest req = request;
        Challenge challenge = request.getChallenge().orElse(null);
        if (challenge instanceof BearerTokenChallenge) {
            BearerTokenChallenge token = (BearerTokenChallenge)challenge;
            req = req.addHeader("Authorization", token.getToken().toHeaderValue());
        }
        return req;
    }

    @Override
    public HTTPRequest prepareWithProxy(HTTPRequest request, Challenge challenge, AuthScheme scheme) {
        throw new UnsupportedOperationException("Proxy authentication is not handled by the Bearer spec");
    }

    @Override
    public AuthScheme afterSuccessfulAuthentication(AuthScheme scheme, Headers headers) {
        return scheme;
    }

    @Override
    public AuthScheme afterSuccessfulProxyAuthentication(AuthScheme scheme, Headers headers) {
        throw new UnsupportedOperationException("Proxy authentication is not handled by the Bearer spec");
    }
}

