/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.auth;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.codehaus.httpcache4j.HTTPHost;
import org.codehaus.httpcache4j.auth.ChallengeProvider;

public class ProxyConfiguration {
    private HTTPHost host;
    private final Set<String> ignoredHosts = new CopyOnWriteArraySet<String>();
    private final ChallengeProvider provider;

    public ProxyConfiguration() {
        this(null, null, null);
    }

    public ProxyConfiguration(HTTPHost host, String ignoredHosts, ChallengeProvider provider) {
        this.host = host;
        this.provider = provider != null ? provider : new ChallengeProvider.Stub();
        this.ignoredHosts.addAll(this.parseIgnoreableHosts(ignoredHosts));
    }

    private Collection<String> parseIgnoreableHosts(String ignoredHosts) {
        if (!Objects.toString(ignoredHosts, "").isEmpty()) {
            if (ignoredHosts.contains("|")) {
                return Arrays.asList(ignoredHosts.split("\\|"));
            }
            if (ignoredHosts.contains(",")) {
                return Arrays.asList(ignoredHosts.split(","));
            }
        }
        return Collections.emptySet();
    }

    public boolean isHostIgnored(String host) {
        for (String candidate : this.ignoredHosts) {
            if ((candidate = candidate.trim()).startsWith("*") && host.contains(candidate.substring(1))) {
                return true;
            }
            if (candidate.endsWith("*") && host.contains(candidate.substring(0, candidate.length() - 1))) {
                return true;
            }
            if (!host.equals(candidate)) continue;
            return true;
        }
        return false;
    }

    public HTTPHost getHost() {
        return this.host;
    }

    public Set<String> getIgnoredHosts() {
        return this.ignoredHosts;
    }

    public ChallengeProvider getProvider() {
        return this.provider;
    }
}

