/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.codehaus.httpcache4j.Directive;
import org.codehaus.httpcache4j.Directives;
import org.codehaus.httpcache4j.LinkDirective;
import org.codehaus.httpcache4j.Parameter;
import org.codehaus.httpcache4j.QuotedDirective;
import org.codehaus.httpcache4j.QuotedParameter;
import org.codehaus.httpcache4j.util.ParserCursor;

public final class DirectivesParser {
    public static final int CR = 13;
    public static final int LF = 10;
    public static final int SP = 32;
    public static final int HT = 9;
    private static final char PARAM_DELIMITER = ';';
    private static final char ELEM_DELIMITER = ',';
    private static final char[] ALL_DELIMITERS = new char[]{';', ','};

    public static boolean isWhitespace(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\r' || ch == '\n';
    }

    public static Directives parse(String value) {
        if (value.length() > 0) {
            StringBuilder builder = new StringBuilder(value);
            ParserCursor cursor = new ParserCursor(0, value.length());
            DirectivesParser parser = new DirectivesParser();
            return new Directives(parser.parseDirectives(builder, cursor));
        }
        return new Directives();
    }

    private List<Directive> parseDirectives(StringBuilder buffer, ParserCursor cursor) {
        ArrayList<Directive> elements = new ArrayList<Directive>();
        while (!cursor.atEnd()) {
            Directive element = this.parseDirective(buffer, cursor);
            if (element.getName().length() == 0 && element.getValue() == null) continue;
            elements.add(element);
        }
        return elements;
    }

    private Directive parseDirective(StringBuilder buffer, ParserCursor cursor) {
        char ch;
        Parameter parameter = this.parseParameter(buffer, cursor, ALL_DELIMITERS);
        List<Parameter> params = Collections.emptyList();
        if (!cursor.atEnd() && (ch = buffer.charAt(cursor.getPos() - 1)) != ',') {
            params = this.parseParameters(buffer, cursor);
        }
        if (parameter instanceof QuotedParameter) {
            return this.createDirective(parameter.getName(), ((QuotedParameter)parameter).getQuotedValue(), params);
        }
        return this.createDirective(parameter.getName(), parameter.getValue(), params);
    }

    private Directive createDirective(String name, String value, List<Parameter> params) {
        if (DirectivesParser.isQuoted(value)) {
            return new QuotedDirective(name, value, params);
        }
        if ("Link".equals(name)) {
            return new LinkDirective(value, params);
        }
        return new Directive(name, value, params);
    }

    private List<Parameter> parseParameters(StringBuilder buffer, ParserCursor cursor) {
        char ch;
        int pos;
        if (buffer == null) {
            throw new IllegalArgumentException("Char array buffer may not be null");
        }
        if (cursor == null) {
            throw new IllegalArgumentException("Parser cursor may not be null");
        }
        int indexTo = cursor.getUpperBound();
        for (pos = cursor.getPos(); pos < indexTo && DirectivesParser.isWhitespace(ch = buffer.charAt(pos)); ++pos) {
        }
        cursor.updatePos(pos);
        if (cursor.atEnd()) {
            return Collections.emptyList();
        }
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        while (!cursor.atEnd()) {
            params.add(this.parseParameter(buffer, cursor, ALL_DELIMITERS));
            char ch2 = buffer.charAt(cursor.getPos() - 1);
            if (ch2 != ',') continue;
            break;
        }
        return params;
    }

    private static boolean isOneOf(char ch, char[] chars) {
        if (chars != null) {
            for (char chr : chars) {
                if (ch != chr) continue;
                return true;
            }
        }
        return false;
    }

    private Parameter parseParameter(StringBuilder buffer, ParserCursor cursor, char[] delimiters) {
        String name;
        char ch;
        int pos;
        if (buffer == null) {
            throw new IllegalArgumentException("Char array buffer may not be null");
        }
        if (cursor == null) {
            throw new IllegalArgumentException("Parser cursor may not be null");
        }
        boolean terminated = false;
        int indexFrom = cursor.getPos();
        int indexTo = cursor.getUpperBound();
        for (pos = cursor.getPos(); pos < indexTo && (ch = buffer.charAt(pos)) != '='; ++pos) {
            if (!DirectivesParser.isOneOf(ch, delimiters)) continue;
            terminated = true;
            break;
        }
        if (pos == indexTo) {
            terminated = true;
            name = buffer.substring(indexFrom, indexTo).trim();
        } else {
            name = buffer.substring(indexFrom, pos).trim();
            ++pos;
        }
        if (terminated) {
            cursor.updatePos(pos);
            int i = name.indexOf(60);
            int j = name.indexOf(62);
            if (i != -1 && j != -1) {
                return DirectivesParser.createParameter("Link", name.substring(i + 1, j));
            }
            return DirectivesParser.createParameter(name, null);
        }
        int i1 = pos;
        boolean qouted = false;
        boolean escaped = false;
        while (pos < indexTo) {
            char ch2 = buffer.charAt(pos);
            if (ch2 == '\"' && !escaped) {
                boolean bl = qouted = !qouted;
            }
            if (!qouted && !escaped && DirectivesParser.isOneOf(ch2, delimiters)) {
                terminated = true;
                break;
            }
            escaped = escaped ? false : qouted && ch2 == '\\';
            ++pos;
        }
        int i2 = pos;
        while (i1 < i2 && DirectivesParser.isWhitespace(buffer.charAt(i1))) {
            ++i1;
        }
        while (i2 > i1 && DirectivesParser.isWhitespace(buffer.charAt(i2 - 1))) {
            --i2;
        }
        String value = buffer.substring(i1, i2);
        if (terminated) {
            ++pos;
        }
        cursor.updatePos(pos);
        return DirectivesParser.createParameter(name, value);
    }

    static Parameter createParameter(String name, String value) {
        if (value != null && DirectivesParser.isQuoted(value)) {
            return new QuotedParameter(name, value);
        }
        return new Parameter(name, value);
    }

    static boolean isQuoted(String value) {
        return value.startsWith("\"") && value.endsWith("\"");
    }
}

