/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.payload;

import com.google.common.base.Charsets;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.codehaus.httpcache4j.MIMEType;
import org.codehaus.httpcache4j.payload.ByteArrayPayload;
import org.codehaus.httpcache4j.payload.Payload;

public final class StringPayload
implements Payload {
    private final ByteArrayPayload delegate;

    public StringPayload(String value, MIMEType mimeType) {
        this(value, mimeType, Charsets.UTF_8);
    }

    public StringPayload(String value, MIMEType mimeType, Charset charset) {
        this.delegate = new ByteArrayPayload(value.getBytes(charset), mimeType);
    }

    @Override
    public MIMEType getMimeType() {
        return this.delegate.getMimeType();
    }

    @Override
    public InputStream getInputStream() {
        return this.delegate.getInputStream();
    }

    @Override
    public long length() {
        return this.delegate.length();
    }

    @Override
    public boolean isAvailable() {
        return this.delegate.isAvailable();
    }
}

