/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.resolver;

import com.google.common.base.Optional;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.httpcache4j.HTTPHost;

public class ConnectionConfiguration {
    private final Optional<Integer> timeout;
    private final Optional<Integer> socketTimeout;
    private final Optional<Integer> defaultConnectionsPerHost;
    private final Optional<Integer> maxConnections;
    private final Map<HTTPHost, Integer> connectionsPerHost = new HashMap<HTTPHost, Integer>();

    public ConnectionConfiguration(Optional<Integer> timeout, Optional<Integer> socketTimeout, Optional<Integer> defaultConnectionsPerHost, Optional<Integer> maxConnections, Map<HTTPHost, Integer> connectionsPerHost) {
        this.timeout = timeout;
        this.socketTimeout = socketTimeout;
        this.defaultConnectionsPerHost = defaultConnectionsPerHost;
        this.maxConnections = maxConnections;
        this.connectionsPerHost.putAll(connectionsPerHost);
    }

    public ConnectionConfiguration() {
        this((Optional<Integer>)Optional.absent(), (Optional<Integer>)Optional.absent(), (Optional<Integer>)Optional.absent(), (Optional<Integer>)Optional.absent(), Collections.emptyMap());
    }

    public Optional<Integer> getTimeout() {
        return this.timeout;
    }

    public Optional<Integer> getSocketTimeout() {
        return this.socketTimeout;
    }

    public Optional<Integer> getDefaultConnectionsPerHost() {
        return this.defaultConnectionsPerHost;
    }

    public Optional<Integer> getMaxConnections() {
        return this.maxConnections;
    }

    public Map<HTTPHost, Integer> getConnectionsPerHost() {
        return this.connectionsPerHost;
    }

    public static class Builder {
        private Optional<Integer> timeout = Optional.absent();
        private Optional<Integer> socketTimeout = Optional.absent();
        private Optional<Integer> defaultConnectionPerHost = Optional.absent();
        private Optional<Integer> maxConnections = Optional.absent();
        private final Map<HTTPHost, Integer> connectionsPerHost = new HashMap<HTTPHost, Integer>();

        public Builder setTimeout(int timeout) {
            this.timeout = Optional.of((Object)timeout);
            return this;
        }

        public Builder setSocketTimeout(int socketTimeout) {
            this.socketTimeout = Optional.of((Object)socketTimeout);
            return this;
        }

        public Builder setDefaultConnectionPerHost(int defaultConnectionPerHost) {
            this.defaultConnectionPerHost = Optional.of((Object)defaultConnectionPerHost);
            return this;
        }

        public Builder setMaxConnections(int maxConnections) {
            this.maxConnections = Optional.of((Object)maxConnections);
            return this;
        }

        public Builder add(HTTPHost host, int connections) {
            this.connectionsPerHost.put(host, connections);
            return this;
        }

        public ConnectionConfiguration build() {
            return new ConnectionConfiguration(this.timeout, this.socketTimeout, this.defaultConnectionPerHost, this.maxConnections, this.connectionsPerHost);
        }
    }
}

