/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.auth;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.codehaus.httpcache4j.HTTPHost;
import org.codehaus.httpcache4j.HTTPRequest;
import org.codehaus.httpcache4j.HTTPResponse;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.Status;
import org.codehaus.httpcache4j.auth.AuthScheme;
import org.codehaus.httpcache4j.auth.Authenticator;
import org.codehaus.httpcache4j.auth.AuthenticatorBase;
import org.codehaus.httpcache4j.auth.AuthenticatorStrategy;
import org.codehaus.httpcache4j.util.Pair;

public class DefaultAuthenticator
extends AuthenticatorBase
implements Authenticator {
    public DefaultAuthenticator() {
    }

    public DefaultAuthenticator(List<AuthenticatorStrategy> strategies) {
        super(strategies);
    }

    @Override
    public final HTTPRequest prepareAuthentication(HTTPRequest request, HTTPResponse response) {
        Pair<AuthenticatorStrategy, AuthScheme> selected;
        List<AuthScheme> schemes;
        HTTPRequest req = request;
        HTTPHost host = new HTTPHost(request.getRequestURI());
        if (response == null && this.registry.matches(host)) {
            AuthScheme authScheme = this.registry.get(host);
            Pair<AuthenticatorStrategy, AuthScheme> selected2 = this.select((List<AuthScheme>)ImmutableList.of((Object)authScheme));
            return selected2.getKey().prepare(request, authScheme);
        }
        if (response != null && response.getStatus() == Status.UNAUTHORIZED && !(schemes = this.toAuthSchemes(response, "WWW-Authenticate")).isEmpty() && request.getChallenge() != null && (selected = this.select(schemes)).getValue() != null && (req = selected.getKey().prepare(request, selected.getValue())) != request) {
            this.registry.register(host, selected.getValue());
        }
        return req;
    }

    @Override
    public boolean canAuthenticatePreemptively(HTTPRequest request) {
        return this.canAuthenticatePreemptively(new HTTPHost(request.getRequestURI()));
    }

    @Override
    public HTTPRequest preparePreemptiveAuthentication(HTTPRequest request) {
        return this.prepareAuthentication(request, null);
    }

    @Override
    public void afterSuccessfulAuthentication(HTTPRequest request, Headers responseHeaders) {
        AuthScheme scheme;
        Pair<AuthenticatorStrategy, AuthScheme> select;
        AuthScheme updatedScheme;
        HTTPHost host = new HTTPHost(request.getRequestURI());
        if (this.registry.matches(host) && (updatedScheme = (select = this.select((List<AuthScheme>)ImmutableList.of((Object)(scheme = this.registry.get(host))))).getKey().afterSuccessfulAuthentication(scheme, responseHeaders)) != scheme) {
            this.registry.register(host, updatedScheme);
        }
    }

    @Override
    public void afterFailedAuthentication(HTTPRequest request, Headers responseHeaders) {
        HTTPHost host = new HTTPHost(request.getRequestURI());
        this.registry.remove(host);
    }
}

