/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Locale;
import org.codehaus.httpcache4j.CacheControl;
import org.codehaus.httpcache4j.Directive;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.LinkDirective;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public final class HeaderUtils {
    public static final String PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss 'GMT'";
    private static final String NO_CACHE_HEADER_VALUE = "no-cache";
    private static final Header VARY_ALL = new Header("Vary", "*");
    private static List<String> UNCACHEABLE_HEADERS = ImmutableList.of((Object)"Set-Cookie", (Object)"Proxy-Authenticate", (Object)"WWW-Authenticate");

    private HeaderUtils() {
    }

    public static DateTime fromHttpDate(Header header) {
        if (header == null) {
            return null;
        }
        if ("0".equals(header.getValue().trim())) {
            return new DateTime(1970, 1, 1, 0, 0, 0, 0).withZone(DateTimeZone.forID((String)"UTC"));
        }
        return HeaderUtils.parseGMTString(header.getValue());
    }

    public static DateTime parseGMTString(String value) {
        DateTimeFormatter formatter = HeaderUtils.getFormatter();
        DateTime formattedDate = null;
        try {
            formattedDate = formatter.parseDateTime(value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return formattedDate;
    }

    public static Header toHttpDate(String headerName, DateTime time) {
        return new Header(headerName, HeaderUtils.toGMTString(time));
    }

    public static String toGMTString(DateTime time) {
        DateTimeFormatter formatter = HeaderUtils.getFormatter();
        return formatter.print((ReadableInstant)time);
    }

    private static DateTimeFormatter getFormatter() {
        return DateTimeFormat.forPattern((String)PATTERN_RFC1123).withZone(DateTimeZone.forID((String)"UTC")).withLocale(Locale.US);
    }

    public static long getHeaderAsDate(Header header) {
        try {
            DateTime dateTime = HeaderUtils.fromHttpDate(header);
            if (dateTime != null) {
                return dateTime.getMillis();
            }
        }
        catch (Exception e) {
            return -1L;
        }
        return -1L;
    }

    static Headers cleanForCaching(Headers headers) {
        for (String headerName : UNCACHEABLE_HEADERS) {
            headers = headers.remove(headerName);
        }
        return headers;
    }

    public static boolean hasCacheableHeaders(Headers headers) {
        Header header;
        CacheControl cc;
        if (headers.contains(VARY_ALL)) {
            return false;
        }
        if (headers.contains("Cache-Control") && ((cc = new CacheControl(header = headers.getFirstHeader("Cache-Control"))).isNoCache() || cc.isNoStore())) {
            return false;
        }
        if (headers.contains("Pragma") && (header = headers.getFirstHeader("Pragma")).getValue().contains(NO_CACHE_HEADER_VALUE)) {
            return false;
        }
        if (headers.contains("Expires")) {
            Header expires = headers.getFirstHeader("Expires");
            DateTime expiresValue = HeaderUtils.fromHttpDate(expires);
            Header date = headers.getFirstHeader("Date");
            if (expiresValue == null || date == null) {
                return false;
            }
            DateTime dateValue = HeaderUtils.fromHttpDate(date);
            if (expiresValue.isBefore((ReadableInstant)dateValue) || expiresValue.equals((Object)dateValue)) {
                return false;
            }
        }
        return true;
    }

    static String removeQuotes(String value) {
        if (value != null && value.startsWith("\"") && value.endsWith("\"")) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    public static Header toLinkHeader(List<LinkDirective> linkDirectives) {
        StringBuilder builder = new StringBuilder();
        for (LinkDirective linkDirective : linkDirectives) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(linkDirective);
        }
        return new Header("Link", builder.toString());
    }

    public static List<LinkDirective> toLinkDirectives(Header header) {
        Preconditions.checkArgument((!"Link".equals(header.getName()) ? 1 : 0) != 0, (Object)"This must be a \"Link\" header");
        ImmutableList.Builder links = ImmutableList.builder();
        for (Directive directive : header.getDirectives()) {
            if (directive instanceof LinkDirective) {
                links.add((Object)((LinkDirective)directive));
                continue;
            }
            links.add((Object)new LinkDirective(directive.getName(), directive.getParameters()));
        }
        return links.build();
    }
}

