/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class IOUtils {
    private static final int BUF_SIZE = 4096;

    private IOUtils() {
    }

    public static long copy(InputStream from, OutputStream to) throws IOException {
        int r;
        if (from == null) {
            throw new IllegalArgumentException("null from not allowed");
        }
        if (to == null) {
            throw new IllegalArgumentException("null to not allowed");
        }
        byte[] buf = new byte[4096];
        long total = 0L;
        while ((r = from.read(buf)) != -1) {
            to.write(buf, 0, r);
            total += (long)r;
        }
        return total;
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

