/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.util;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.codehaus.httpcache4j.Parameter;
import org.codehaus.httpcache4j.Parameters;
import org.codehaus.httpcache4j.util.URIDecoder;
import org.codehaus.httpcache4j.util.URIEncoder;
import org.codehaus.httpcache4j.util.URISchemeDefaults;

public final class URIBuilder {
    public static AtomicReference<URISchemeDefaults> schemeDefaults = new AtomicReference<URISchemeDefaults>(new URISchemeDefaults());
    private final String scheme;
    private final String host;
    private final int port;
    private final List<Path> path;
    private final String fragment;
    private final Parameters parameters;
    private final boolean wasPathAbsolute;
    private final boolean endsWithSlash;
    private final String schemeSpecificPart;
    private static Function<String, Path> stringToPath = new Function<String, Path>(){

        public Path apply(String from) {
            return new Path(from);
        }
    };
    private static Function<Path, String> pathToString = new Function<Path, String>(){

        public String apply(Path from) {
            return from.getValue();
        }
    };
    private static Function<Path, String> encodedPathToString = new Function<Path, String>(){

        public String apply(Path from) {
            return from.getEncodedValue();
        }
    };

    private URIBuilder(String scheme, String schemeSpecificPart, String host, int port, List<Path> path, String fragment, Parameters parameters, boolean wasPathAbsolute, boolean endsWithSlash) {
        this.scheme = scheme;
        this.schemeSpecificPart = schemeSpecificPart;
        this.host = host;
        this.port = port;
        this.path = path;
        this.fragment = fragment;
        this.parameters = parameters;
        this.wasPathAbsolute = wasPathAbsolute;
        this.endsWithSlash = endsWithSlash;
    }

    public URIBuilder withHost(String host) {
        return new URIBuilder(this.scheme, this.schemeSpecificPart, host, this.port, this.path, this.fragment, this.parameters, this.wasPathAbsolute, this.endsWithSlash);
    }

    public URIBuilder withPort(int port) {
        Optional<Integer> defaultPort = schemeDefaults.get().getPort(this.scheme);
        if (defaultPort.isPresent() && port == (Integer)defaultPort.get()) {
            port = -1;
        }
        return new URIBuilder(this.scheme, this.schemeSpecificPart, this.host, port, this.path, this.fragment, this.parameters, this.wasPathAbsolute, this.endsWithSlash);
    }

    private boolean isURN() {
        return this.scheme != null && this.scheme.startsWith("urn");
    }

    public URIBuilder withScheme(String scheme) {
        return new URIBuilder(scheme, this.schemeSpecificPart, this.host, this.port, this.path, this.fragment, this.parameters, this.wasPathAbsolute, this.endsWithSlash);
    }

    public URIBuilder addRawPath(String path) {
        boolean pathAbsolute = this.wasPathAbsolute || this.path.isEmpty() && path.startsWith("/");
        boolean endsWithSlash = this.endsWithSlash || this.path.isEmpty() && path.endsWith("/");
        List<Path> appendedPath = URIBuilder.toPathParts(path);
        ImmutableList.Builder currentPath = ImmutableList.builder();
        currentPath.addAll(this.path);
        currentPath.addAll(appendedPath);
        return new URIBuilder(this.scheme, this.schemeSpecificPart, this.host, this.port, (List<Path>)currentPath.build(), this.fragment, this.parameters, pathAbsolute, endsWithSlash);
    }

    public URIBuilder addPath(List<String> path) {
        List appendedPath = Lists.transform(path, stringToPath);
        ImmutableList.Builder currentPath = ImmutableList.builder();
        currentPath.addAll(this.path);
        currentPath.addAll((Iterable)appendedPath);
        return new URIBuilder(this.scheme, this.schemeSpecificPart, this.host, this.port, (List<Path>)currentPath.build(), this.fragment, this.parameters, this.wasPathAbsolute, this.endsWithSlash);
    }

    public URIBuilder addPath(String ... path) {
        return this.addPath(Arrays.asList(path));
    }

    public URIBuilder withPath(String ... path) {
        return this.withPath(Arrays.asList(path));
    }

    public URIBuilder withPath(List<String> pathList) {
        List paths = Lists.transform(pathList, stringToPath);
        return this.pathInternal(paths, false, false);
    }

    public URIBuilder withRawPath(String path) {
        boolean pathAbsoulute = path.startsWith("/");
        boolean endsWithSlash = path.endsWith("/");
        List<Path> parts = URIBuilder.toPathParts(path);
        return this.pathInternal(parts, pathAbsoulute, endsWithSlash);
    }

    private URIBuilder pathInternal(List<Path> pathList, boolean pathAbsolute, boolean endsWithSlash) {
        return new URIBuilder(this.scheme, this.schemeSpecificPart, this.host, this.port, (List<Path>)ImmutableList.copyOf(pathList), this.fragment, this.parameters, pathAbsolute, endsWithSlash);
    }

    public URIBuilder withFragment(String fragment) {
        return new URIBuilder(this.scheme, this.schemeSpecificPart, this.host, this.port, this.path, fragment, this.parameters, this.wasPathAbsolute, this.endsWithSlash);
    }

    public URIBuilder noParameters() {
        return this.withParameters(this.parameters.empty());
    }

    public URIBuilder withParameters(Iterable<Parameter> parameters) {
        Parameters updated = this.parameters.set(parameters);
        return this.withParameters(updated);
    }

    public URIBuilder withParameters(Map<String, List<String>> params) {
        Parameters updated = this.parameters.set(params);
        return this.withParameters(updated);
    }

    public URIBuilder withParameters(Parameters params) {
        return new URIBuilder(this.scheme, this.schemeSpecificPart, this.host, this.port, this.path, this.fragment, params, this.wasPathAbsolute, this.endsWithSlash);
    }

    public URIBuilder addParameter(String name, String value) {
        return this.addParameter(new Parameter(name, value));
    }

    public URIBuilder addParameter(Parameter parameter) {
        return this.addParameters(Arrays.asList(parameter));
    }

    public URIBuilder addParameters(List<Parameter> newParams) {
        if (newParams.isEmpty()) {
            return this;
        }
        Parameters updated = this.parameters.add(newParams);
        return this.withParameters(updated);
    }

    public URIBuilder addParameters(Map<String, List<String>> newParams) {
        if (newParams.isEmpty()) {
            return this;
        }
        Parameters updated = this.parameters.add(newParams);
        return this.withParameters(updated);
    }

    public URIBuilder removeParameters(String name) {
        return this.withParameters(this.parameters.remove(name));
    }

    public URIBuilder replaceParameter(String name, String value) {
        return this.withParameters(this.parameters.set(name, value));
    }

    private String toPath(boolean encodepath) {
        if (this.path.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (Path pathElement : this.path) {
            if (builder.length() > 0) {
                builder.append("/");
            }
            builder.append(encodepath ? pathElement.getEncodedValue() : pathElement.getValue());
        }
        if ((this.wasPathAbsolute || this.host != null) && builder.length() > 1 && !"/".equals(builder.substring(0, 1))) {
            builder.insert(0, "/");
        }
        if (this.endsWithSlash) {
            builder.append("/");
        }
        return builder.toString();
    }

    public URI toURI() {
        return this.toURI(true, false, false);
    }

    public URI toNormalizedURI(boolean encodePath) {
        return this.toURI(encodePath, true, false).normalize();
    }

    public URI toNormalizedURI() {
        return this.toNormalizedURI(true);
    }

    public boolean isRelative() {
        return this.scheme == null && this.host == null;
    }

    public URI toAbsoluteURI() {
        return this.toURI(true, false, true);
    }

    private URI toURI(boolean encodePath, boolean sortQP, boolean absolutify) {
        try {
            if (this.isURN()) {
                return new URI(this.scheme, this.schemeSpecificPart, this.fragment);
            }
            StringBuilder sb = new StringBuilder();
            if (this.scheme != null) {
                sb.append(this.scheme);
                sb.append("://");
            }
            if (this.host != null) {
                sb.append(this.host);
            }
            if (this.port > -1) {
                sb.append(":").append(this.port);
            }
            if (!this.path.isEmpty()) {
                String path = this.toPath(encodePath);
                if (absolutify && this.isRelative() && !path.startsWith("/")) {
                    path = "/" + path;
                }
                sb.append(path);
            }
            if (!this.parameters.isEmpty()) {
                sb.append("?");
                sb.append(this.parameters.toQuery(sortQP));
            }
            if (this.fragment != null) {
                sb.append("#");
                sb.append(this.fragment);
            }
            return URI.create(sb.toString());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    public List<Parameter> getParametersByName(final String name) {
        List<String> params = this.parameters.get(name);
        if (params == null) {
            return Collections.emptyList();
        }
        return Lists.transform(params, (Function)new Function<String, Parameter>(){

            public Parameter apply(String s) {
                return new Parameter(name, s);
            }
        });
    }

    public String getFirstParameterValueByName(String name) {
        return this.parameters.getFirst(name);
    }

    public static URIBuilder fromURI(URI uri) {
        boolean pathAbsoluteness = uri.getPath() != null && uri.getPath().startsWith("/");
        boolean endsWithSlash = uri.getPath() != null && uri.getPath().endsWith("/");
        return new URIBuilder(uri.getScheme(), uri.getSchemeSpecificPart(), uri.getHost(), uri.getPort(), URIBuilder.toPathParts(uri.getPath()), uri.getFragment(), Parameters.parse(uri.getQuery()), pathAbsoluteness, endsWithSlash);
    }

    public static URIBuilder empty() {
        return new URIBuilder(null, "", null, -1, Collections.<Path>emptyList(), null, new Parameters(), false, false);
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public List<String> getPath() {
        return Lists.transform(this.path, pathToString);
    }

    public List<String> getEncodedPath() {
        return Lists.transform(this.path, encodedPathToString);
    }

    public String getCurrentPath() {
        return this.toPath(false);
    }

    public String getFragment() {
        return this.fragment;
    }

    public Iterable<Parameter> getParameters() {
        return this.parameters;
    }

    public Parameters getParametersAsObject() {
        return this.parameters;
    }

    public Map<String, List<String>> getParametersAsMap() {
        return this.parameters.asMap();
    }

    @Deprecated
    public static Map<String, List<String>> toQueryMap(String query) {
        return Parameters.parse(query).asMap();
    }

    private static List<Path> toPathParts(String path) {
        if (path == null) {
            return Collections.emptyList();
        }
        if (!path.contains("/")) {
            return Collections.singletonList(new Path(path));
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        List<String> stringList = Arrays.asList(path.split("/"));
        return ImmutableList.copyOf((Collection)Lists.transform(stringList, stringToPath));
    }

    private static class Path {
        private final String value;

        private Path(String value) {
            this.value = URIDecoder.decodeUTF8(value);
        }

        String getEncodedValue() {
            return URIEncoder.encodeUTF8(this.value);
        }

        String getValue() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }
    }
}

