/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.resolver;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.codehaus.httpcache4j.HTTPRequest;
import org.codehaus.httpcache4j.HTTPResponse;
import org.codehaus.httpcache4j.Status;
import org.codehaus.httpcache4j.auth.Authenticator;
import org.codehaus.httpcache4j.auth.ProxyAuthenticator;
import org.codehaus.httpcache4j.resolver.ResolverConfiguration;
import org.codehaus.httpcache4j.resolver.ResponseCreator;
import org.codehaus.httpcache4j.resolver.ResponseResolver;

public abstract class AbstractResponseResolver
implements ResponseResolver {
    private final ResponseCreator responseCreator = new ResponseCreator();
    private final ResolverConfiguration configuration;

    protected AbstractResponseResolver(ResolverConfiguration configuration) {
        this.configuration = (ResolverConfiguration)Preconditions.checkNotNull((Object)configuration, (Object)"Configuration may not be null");
    }

    protected final ProxyAuthenticator getProxyAuthenticator() {
        return this.configuration.getProxyAuthenticator();
    }

    protected ResponseCreator getResponseCreator() {
        return this.responseCreator;
    }

    protected final Authenticator getAuthenticator() {
        return this.configuration.getAuthenticator();
    }

    protected final ResolverConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public final HTTPResponse resolve(HTTPRequest request) throws IOException {
        return this.resolveAuthenticated(request, request);
    }

    private HTTPResponse resolveAuthenticated(HTTPRequest request, HTTPRequest req) throws IOException {
        HTTPResponse convertedResponse;
        if (this.getAuthenticator().canAuthenticatePreemptively(request)) {
            req = this.getAuthenticator().preparePreemptiveAuthentication(request);
        }
        if (this.getProxyAuthenticator().canAuthenticatePreemptively()) {
            req = this.getProxyAuthenticator().preparePreemptiveAuthentication(req);
        }
        if ((convertedResponse = this.resolveImpl(req)).getStatus() == Status.PROXY_AUTHENTICATION_REQUIRED && (req = this.getProxyAuthenticator().prepareAuthentication(req, convertedResponse)) != request) {
            convertedResponse.consume();
            convertedResponse = this.resolveImpl(req);
            if (convertedResponse.getStatus() == Status.PROXY_AUTHENTICATION_REQUIRED) {
                this.getProxyAuthenticator().afterFailedAuthentication(convertedResponse.getHeaders());
            } else {
                this.getProxyAuthenticator().afterSuccessfulAuthentication(convertedResponse.getHeaders());
            }
        }
        if (convertedResponse.getStatus() == Status.UNAUTHORIZED && (req = this.getAuthenticator().prepareAuthentication(req, convertedResponse)) != request) {
            convertedResponse.consume();
            convertedResponse = this.resolveImpl(req);
            if (convertedResponse.getStatus() == Status.UNAUTHORIZED) {
                this.getAuthenticator().afterFailedAuthentication(req, convertedResponse.getHeaders());
            } else {
                this.getAuthenticator().afterSuccessfulAuthentication(req, convertedResponse.getHeaders());
            }
        }
        return convertedResponse;
    }

    protected abstract HTTPResponse resolveImpl(HTTPRequest var1) throws IOException;
}

