/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.util;

import java.io.PrintStream;
import org.codehaus.httpcache4j.HTTPRequest;
import org.codehaus.httpcache4j.HeaderUtils;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.util.AbstractHTTPWriter;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class RequestWriter
extends AbstractHTTPWriter {
    public void write(HTTPRequest request) {
        this.write(System.out, request);
    }

    public void write(PrintStream stream, HTTPRequest request) {
        this.writeRequestLine(stream, request);
        Headers all = request.getAllHeaders();
        all = all.add(HeaderUtils.toHttpDate("Date", new DateTime(DateTimeZone.forID((String)"UTC"))));
        all = all.add("Connection", "close");
        this.writeHeaders(stream, all);
        if (request.hasPayload()) {
            this.writeBody(stream, request.getPayload());
        }
        stream.print("\r\n");
        stream.flush();
    }

    private void writeRequestLine(PrintStream writer, HTTPRequest request) {
        writer.print(String.format("%s %s HTTP/1.1\r\n", request.getMethod().toString(), request.getRequestURI().getPath()));
    }
}

