/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.payload;

import com.google.common.base.Preconditions;
import java.io.InputStream;
import org.codehaus.httpcache4j.MIMEType;
import org.codehaus.httpcache4j.payload.Payload;
import org.codehaus.httpcache4j.util.AvailableInputStream;

public class InputStreamPayload
implements Payload {
    private final AvailableInputStream stream;
    private final MIMEType mimeType;
    private final long length;

    public InputStreamPayload(InputStream stream, MIMEType mimeType) {
        this(stream, mimeType, -1L);
    }

    public InputStreamPayload(InputStream stream, MIMEType mimeType, long length) {
        this.mimeType = mimeType != null ? mimeType : MIMEType.APPLICATION_OCTET_STREAM;
        this.stream = new AvailableInputStream((InputStream)Preconditions.checkNotNull((Object)stream, (Object)"Inputstream may not be null"));
        this.length = length;
    }

    @Override
    public MIMEType getMimeType() {
        return this.mimeType;
    }

    @Override
    public boolean isAvailable() {
        return this.stream.isAvailable();
    }

    @Override
    public InputStream getInputStream() {
        return this.stream.isAvailable() ? this.stream : null;
    }

    @Override
    public long length() {
        return this.length;
    }
}

