/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.auth;

import org.codehaus.httpcache4j.Challenge;
import org.codehaus.httpcache4j.HTTPRequest;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.UsernamePasswordChallenge;
import org.codehaus.httpcache4j.auth.AuthScheme;
import org.codehaus.httpcache4j.auth.AuthenticatorStrategy;
import org.codehaus.httpcache4j.auth.BasicAuthentication;

public class BasicAuthenticatorStrategy
implements AuthenticatorStrategy {
    @Override
    public boolean supports(AuthScheme scheme) {
        return "basic".equalsIgnoreCase(scheme.getType());
    }

    @Override
    public HTTPRequest prepare(HTTPRequest request, AuthScheme scheme) {
        return this.prepare(request, request.getChallenge(), false);
    }

    @Override
    public HTTPRequest prepareWithProxy(HTTPRequest request, Challenge challenge, AuthScheme scheme) {
        return this.prepare(request, challenge, true);
    }

    private HTTPRequest prepare(HTTPRequest request, Challenge challenge, boolean proxy) {
        HTTPRequest req = request;
        if (challenge instanceof UsernamePasswordChallenge) {
            UsernamePasswordChallenge upc = (UsernamePasswordChallenge)challenge;
            String authValue = BasicAuthentication.getHeaderValue(upc);
            req = proxy ? request.addHeader("Proxy-Authorization", authValue) : request.addHeader("Authorization", authValue);
        }
        return req;
    }

    @Override
    public AuthScheme afterSuccessfulAuthentication(AuthScheme scheme, Headers headers) {
        return scheme;
    }

    @Override
    public AuthScheme afterSuccessfulProxyAuthentication(AuthScheme scheme, Headers headers) {
        return scheme;
    }
}

