/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.codehaus.httpcache4j.HTTPException;
import org.codehaus.httpcache4j.HTTPRequest;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.HeaderUtils;
import org.codehaus.httpcache4j.payload.Payload;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class RequestWriter {
    private final HTTPRequest request;

    public RequestWriter(HTTPRequest request) {
        this.request = request;
    }

    public void write() {
        this.write(new PrintWriter(System.out));
    }

    public void write(Writer target) {
        PrintWriter writer = new PrintWriter(target);
        this.writeRequestLine(writer);
        this.writeGeneralHeaders(writer);
        this.writerRequestHeaders(writer);
        if (this.request.hasPayload()) {
            this.writeBody(writer, this.request.getPayload());
        }
        writer.print("\r\n");
        writer.flush();
    }

    private void writeRequestLine(PrintWriter writer) {
        writer.println(String.format("%s %s HTTP/1.1", this.request.getMethod().toString(), this.request.getRequestURI().getPath()));
    }

    private void writeGeneralHeaders(PrintWriter writer) {
        Header dateHeader = HeaderUtils.toHttpDate("Date", new DateTime(DateTimeZone.forID((String)"UTC")));
        writer.println(dateHeader);
        writer.println("Connection: close");
    }

    private void writerRequestHeaders(PrintWriter writer) {
        for (Header head : this.request.getAllHeaders()) {
            writer.println(head.toString());
        }
    }

    private void writeBody(PrintWriter writer, Payload payload) {
        InputStream stream = payload.getInputStream();
        try {
            IOUtils.copy((InputStream)stream, (Writer)writer);
        }
        catch (IOException e) {
            throw new HTTPException("Unable to write the body of the response", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }
}

