/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.preference;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.MIMEType;
import org.codehaus.httpcache4j.preference.LocalePreference;
import org.codehaus.httpcache4j.preference.Preference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Preferences {
    private final List<Preference<Locale>> locales;
    private final List<Preference<MIMEType>> MIMETypes;
    private final List<Preference<String>> charsets;
    private static final double IGNORED_QUALITY = 1.0;

    public Preferences() {
        this(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    private Preferences(List<Preference<Locale>> locales, List<Preference<MIMEType>> MIMETypes, List<Preference<String>> charsets) {
        this.locales = locales;
        this.MIMETypes = MIMETypes;
        this.charsets = charsets;
    }

    public Preferences addLocale(Locale locale) {
        return this.addLocale(locale, 1.0);
    }

    public Preferences addLocale(Locale locale, double quality) {
        ArrayList<Preference<Locale>> locales = new ArrayList<Preference<Locale>>(this.locales);
        LocalePreference preference = new LocalePreference(locale, quality);
        if (!locales.contains(preference)) {
            locales.add(preference);
        }
        return new Preferences(Collections.unmodifiableList(locales), this.MIMETypes, this.charsets);
    }

    public Preferences addMIMEType(MIMEType mimeType, double quality) {
        ArrayList<Preference<MIMEType>> MIMETypes = new ArrayList<Preference<MIMEType>>(this.MIMETypes);
        Preference<MIMEType> mime = new Preference<MIMEType>(mimeType, quality);
        if (!MIMETypes.contains(mime)) {
            MIMETypes.add(mime);
        }
        return new Preferences(this.locales, Collections.unmodifiableList(MIMETypes), this.charsets);
    }

    public Preferences addMIMEType(MIMEType mimeType) {
        return this.addMIMEType(mimeType, 1.0);
    }

    public Preferences addCharset(String charset) {
        return this.addCharset(charset, 1.0);
    }

    public Preferences addCharset(String charset, double quality) {
        ArrayList<Preference<String>> charsets = new ArrayList<Preference<String>>();
        Preference<String> preference = new Preference<String>(charset, quality);
        if (!charsets.contains(preference)) {
            charsets.add(preference);
        }
        return new Preferences(this.locales, this.MIMETypes, Collections.unmodifiableList(charsets));
    }

    public List<Preference<Locale>> getAcceptLocales() {
        return this.locales;
    }

    public List<Preference<MIMEType>> getAcceptMIMETypes() {
        return this.MIMETypes;
    }

    public List<Preference<String>> getAcceptCharset() {
        return this.charsets;
    }

    public Headers toHeaders() {
        Headers headers = new Headers();
        if (!this.getAcceptMIMETypes().isEmpty()) {
            headers = headers.add(Preferences.toHeader("Accept", this.getAcceptMIMETypes()));
        }
        if (!this.getAcceptLocales().isEmpty()) {
            headers = headers.add(Preferences.toHeader("Accept-Language", this.getAcceptLocales()));
        }
        if (!this.getAcceptCharset().isEmpty()) {
            headers = headers.add(Preferences.toHeader("Accept-Charset", this.getAcceptCharset()));
        }
        return headers;
    }

    static Header toHeader(String headerName, List<? extends Preference<?>> preferences) {
        StringBuilder builder = new StringBuilder();
        for (Preference<?> preference : preferences) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(preference.toString());
        }
        return new Header(headerName, builder.toString());
    }
}

