/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.util;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.httpcache4j.Parameter;
import org.codehaus.httpcache4j.util.URIDecoder;
import org.codehaus.httpcache4j.util.URIEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class URIBuilder {
    private final String scheme;
    private final String host;
    private final int port;
    private final List<Path> path;
    private final String fragment;
    private final Map<String, List<String>> parameters;
    private final boolean wasPathAbsolute;
    private static Function<String, Path> stringToPath = new Function<String, Path>(){

        public Path apply(String from) {
            return new Path(from);
        }
    };
    private static Function<Path, String> pathToString = new Function<Path, String>(){

        public String apply(Path from) {
            return from.getValue();
        }
    };
    private static Function<Path, String> encodedPathToString = new Function<Path, String>(){

        public String apply(Path from) {
            return from.getEncodedValue();
        }
    };

    private URIBuilder(String scheme, String host, int port, List<Path> path, String fragment, Map<String, List<String>> parameters, boolean wasPathAbsolute) {
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.path = path;
        this.fragment = fragment;
        this.parameters = parameters;
        this.wasPathAbsolute = wasPathAbsolute;
    }

    public URIBuilder scheme(String scheme) {
        return new URIBuilder(scheme, this.host, this.port, this.path, this.fragment, this.parameters, this.wasPathAbsolute);
    }

    public URIBuilder addRawPath(String path) {
        boolean pathAbsolute = this.wasPathAbsolute || this.path.isEmpty() && path.startsWith("/");
        List<Path> appendedPath = URIBuilder.toPathParts(path);
        ImmutableList.Builder currentPath = ImmutableList.builder();
        currentPath.addAll(this.path);
        currentPath.addAll(appendedPath);
        return new URIBuilder(this.scheme, this.host, this.port, (List<Path>)currentPath.build(), this.fragment, this.parameters, pathAbsolute);
    }

    public URIBuilder addPath(List<String> path) {
        List appendedPath = Lists.transform(path, stringToPath);
        ImmutableList.Builder currentPath = ImmutableList.builder();
        currentPath.addAll(this.path);
        currentPath.addAll((Iterable)appendedPath);
        return new URIBuilder(this.scheme, this.host, this.port, (List<Path>)currentPath.build(), this.fragment, this.parameters, this.wasPathAbsolute);
    }

    public URIBuilder addPath(String ... path) {
        return this.addPath(Arrays.asList(path));
    }

    public URIBuilder path(String ... path) {
        return this.path(Arrays.asList(path));
    }

    public URIBuilder rawPath(String path) {
        boolean pathAbsoulute = path.startsWith("/");
        List<Path> parts = URIBuilder.toPathParts(path);
        return this.pathInternal(parts, pathAbsoulute);
    }

    public URIBuilder path(List<String> pathList) {
        List paths = Lists.transform(pathList, stringToPath);
        return this.pathInternal(paths, false);
    }

    private URIBuilder pathInternal(List<Path> pathList, boolean pathAbsolute) {
        return new URIBuilder(this.scheme, this.host, this.port, (List<Path>)ImmutableList.copyOf(pathList), this.fragment, this.parameters, pathAbsolute);
    }

    public URIBuilder host(String host) {
        return new URIBuilder(this.scheme, host, this.port, this.path, this.fragment, this.parameters, this.wasPathAbsolute);
    }

    public URIBuilder port(int port) {
        if ("http".equals(this.scheme) && port == 80) {
            port = -1;
        } else if ("https".equals(this.scheme) && port == 443) {
            port = -1;
        }
        return new URIBuilder(this.scheme, this.host, port, this.path, this.fragment, this.parameters, this.wasPathAbsolute);
    }

    public URIBuilder fragment(String fragment) {
        return new URIBuilder(this.scheme, this.host, this.port, this.path, fragment, this.parameters, this.wasPathAbsolute);
    }

    public URIBuilder noParameters() {
        return this.parameters(Collections.<Parameter>emptyList());
    }

    public URIBuilder parameters(List<Parameter> parameters) {
        LinkedHashMap<String, List<String>> paraMap = new LinkedHashMap<String, List<String>>();
        for (Parameter parameter : parameters) {
            URIBuilder.addToQueryMap(paraMap, parameter.getName(), parameter.getValue());
        }
        return new URIBuilder(this.scheme, this.host, this.port, this.path, this.fragment, Collections.unmodifiableMap(paraMap), this.wasPathAbsolute);
    }

    public URIBuilder addParameter(String name, String value) {
        return this.addParameter(new Parameter(name, value));
    }

    public URIBuilder addParameter(Parameter parameter) {
        LinkedHashMap<String, List<String>> parameters = new LinkedHashMap<String, List<String>>(this.parameters);
        URIBuilder.addToQueryMap(parameters, parameter.getName(), parameter.getValue());
        return new URIBuilder(this.scheme, this.host, this.port, this.path, this.fragment, Collections.unmodifiableMap(parameters), this.wasPathAbsolute);
    }

    private String toPath() {
        if (this.path.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (Path pathElement : this.path) {
            if (builder.length() > 0) {
                builder.append("/");
            }
            builder.append(pathElement.getEncodedValue());
        }
        if ((this.wasPathAbsolute || this.host != null) && builder.length() > 1 && !"/".equals(builder.substring(0, 1))) {
            builder.insert(0, "/");
        }
        return builder.toString();
    }

    public URI toURI() {
        try {
            return new URI(this.scheme, null, this.host, this.port, this.toPath(), this.toQuery(), this.fragment);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean isRelative() {
        return this.scheme == null && this.host == null;
    }

    public URI toAbsoluteURI() {
        if (this.isRelative()) {
            try {
                String path = this.toPath();
                if (!path.startsWith("/")) {
                    path = "/" + path;
                }
                return new URI(null, null, null, -1, path, this.toQuery(), this.fragment);
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException(e);
            }
        }
        return this.toURI();
    }

    private String toQuery() {
        StringBuilder builder = new StringBuilder();
        for (Parameter parameter : this.getParametersAsList()) {
            if (builder.length() > 0) {
                builder.append("&");
            }
            builder.append(parameter);
        }
        if (builder.length() == 0) {
            return null;
        }
        return builder.toString();
    }

    private List<Parameter> getParametersAsList() {
        ArrayList<Parameter> list = new ArrayList<Parameter>();
        for (Map.Entry<String, List<String>> entry : this.parameters.entrySet()) {
            for (String value : entry.getValue()) {
                list.add(new Parameter(entry.getKey(), value));
            }
        }
        return list;
    }

    public static URIBuilder fromURI(URI uri) {
        boolean pathAbsoluteness = uri.getPath().startsWith("/");
        return new URIBuilder(uri.getScheme(), uri.getHost(), uri.getPort(), URIBuilder.toPathParts(uri.getPath()), uri.getFragment(), URIBuilder.toQueryMap(uri.getQuery()), pathAbsoluteness);
    }

    public static URIBuilder empty() {
        return new URIBuilder(null, null, -1, Collections.<Path>emptyList(), null, Collections.<String, List<String>>emptyMap(), false);
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public List<String> getPath() {
        return Lists.transform(this.path, pathToString);
    }

    public List<String> getEncodedPath() {
        return Lists.transform(this.path, encodedPathToString);
    }

    public String getCurrentPath() {
        return this.toPath();
    }

    public String getFragment() {
        return this.fragment;
    }

    public List<Parameter> getParameters() {
        return Collections.unmodifiableList(this.getParametersAsList());
    }

    private static Map<String, List<String>> toQueryMap(String query) {
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        if (query != null) {
            String[] parts;
            for (String part : parts = query.split("&")) {
                String[] equalParts = part.split("=");
                String name = null;
                String value = null;
                if (equalParts.length == 1) {
                    name = equalParts[0];
                } else if (equalParts.length == 2) {
                    name = equalParts[0];
                    value = equalParts[1];
                }
                if (name == null) continue;
                URIBuilder.addToQueryMap(map, URIDecoder.decodeUTF8(name), URIDecoder.decodeUTF8(value));
            }
        }
        return Collections.unmodifiableMap(map);
    }

    private static void addToQueryMap(Map<String, List<String>> map, String name, String value) {
        List<String> list = map.get(name);
        if (list == null) {
            list = new ArrayList<String>();
        }
        list.add(value);
        map.put(name, list);
    }

    private static List<Path> toPathParts(String path) {
        if (path == null) {
            return Collections.emptyList();
        }
        if (!path.contains("/")) {
            return Collections.singletonList(new Path(path));
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        List<String> stringList = Arrays.asList(path.split("/"));
        return ImmutableList.copyOf((Collection)Lists.transform(stringList, stringToPath));
    }

    private static class Path {
        private final String value;

        private Path(String value) {
            this.value = URIDecoder.decodeUTF8(value);
        }

        String getEncodedValue() {
            return URIEncoder.encodeUTF8(this.value);
        }

        String getValue() {
            return this.value;
        }
    }
}

