/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

import org.apache.commons.lang.Validate;
import org.codehaus.httpcache4j.HTTPVersion;
import org.codehaus.httpcache4j.Status;

public final class StatusLine {
    private final HTTPVersion version;
    private final String message;
    private final Status status;

    public StatusLine(Status status, String message) {
        this(HTTPVersion.HTTP_1_1, status, message);
    }

    public StatusLine(Status status) {
        this(HTTPVersion.HTTP_1_1, status, null);
    }

    public StatusLine(HTTPVersion version, Status status, String message) {
        Validate.notNull((Object)((Object)version), (String)"Version may not be null");
        Validate.notNull((Object)status, (String)"Status may not be null");
        this.version = version;
        this.status = status;
        this.message = message == null ? "" : message;
    }

    public HTTPVersion getVersion() {
        return this.version;
    }

    public String getMessage() {
        return this.message;
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatusLine that = (StatusLine)o;
        if (this.status != null ? !this.status.equals(that.status) : that.status != null) {
            return false;
        }
        return this.version == that.version;
    }

    public int hashCode() {
        int result = this.version != null ? this.version.hashCode() : 0;
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        return result;
    }
}

