/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.math.NumberUtils;
import org.codehaus.httpcache4j.HeaderUtils;
import org.codehaus.httpcache4j.NameValue;
import org.codehaus.httpcache4j.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Directive
extends NameValue {
    private final List<Parameter> parameters;

    public Directive(String name, String value) {
        this(name, HeaderUtils.fixQuotedString(value), Collections.emptyList());
    }

    public Directive(String name, String value, List<Parameter> parameters) {
        super(name, HeaderUtils.fixQuotedString(value));
        Validate.notNull(parameters, (String)"Paramaters may not be null");
        Validate.noNullElements(parameters, (String)"Parameters may not contain any null elements");
        this.parameters = ImmutableList.copyOf(parameters);
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public int getValueAsInteger() {
        return NumberUtils.toInt((String)this.getValue(), (int)-1);
    }

    @Override
    public String toString() {
        String output = this.name + "=" + this.value;
        if (!this.parameters.isEmpty()) {
            output = output + "; " + Joiner.on((String)"; ").join(this.parameters);
        }
        return output;
    }
}

