/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.auth;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.codehaus.httpcache4j.auth.AuthScheme;
import org.codehaus.httpcache4j.auth.AuthenticatorStrategy;
import org.codehaus.httpcache4j.auth.BasicAuthenticatorStrategy;
import org.codehaus.httpcache4j.auth.DigestAuthenticatorStrategy;
import org.codehaus.httpcache4j.auth.NullAuthenticatorStrategy;
import org.codehaus.httpcache4j.auth.SchemeRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AuthenticatorBase {
    private final List<AuthenticatorStrategy> strategies = Lists.newArrayList();
    protected final SchemeRegistry registry = new SchemeRegistry();

    public AuthenticatorBase() {
        this(AuthenticatorBase.defaultStrategies());
    }

    public AuthenticatorBase(List<AuthenticatorStrategy> strategies) {
        this.strategies.addAll(strategies);
    }

    protected static List<AuthenticatorStrategy> defaultStrategies() {
        return ImmutableList.of((Object)new DigestAuthenticatorStrategy(), (Object)new BasicAuthenticatorStrategy());
    }

    protected AuthenticatorStrategy select(AuthScheme authScheme) {
        AuthenticatorStrategy selected = null;
        for (AuthenticatorStrategy strategy : this.strategies) {
            if (!strategy.supports(authScheme)) continue;
            selected = strategy;
        }
        if (selected == null) {
            selected = new NullAuthenticatorStrategy();
        }
        return selected;
    }
}

