/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.resolver;

import org.apache.commons.lang.Validate;
import org.codehaus.httpcache4j.auth.Authenticator;
import org.codehaus.httpcache4j.auth.DefaultAuthenticator;
import org.codehaus.httpcache4j.auth.DefaultProxyAuthenticator;
import org.codehaus.httpcache4j.auth.ProxyAuthenticator;
import org.codehaus.httpcache4j.auth.ProxyConfiguration;
import org.codehaus.httpcache4j.resolver.ResponseCreator;
import org.codehaus.httpcache4j.resolver.ResponseResolver;

public abstract class AbstractResponseResolver
implements ResponseResolver {
    private final ResponseCreator responseCreator = new ResponseCreator();
    private final Authenticator authenticator;
    private final ProxyAuthenticator proxyAuthenticator;
    private boolean preemptiveAuthentication = false;

    protected AbstractResponseResolver(ProxyConfiguration proxyConfiguration) {
        Validate.notNull((Object)proxyConfiguration, (String)"Proxy Config may not be null");
        this.authenticator = this.createAuthenticator();
        this.proxyAuthenticator = this.createProxyAuthenticator(proxyConfiguration);
    }

    protected AbstractResponseResolver() {
        this(new ProxyConfiguration());
    }

    protected ProxyAuthenticator createProxyAuthenticator(ProxyConfiguration configuration) {
        return new DefaultProxyAuthenticator(configuration);
    }

    protected Authenticator createAuthenticator() {
        return new DefaultAuthenticator();
    }

    protected ProxyAuthenticator getProxyAuthenticator() {
        return this.proxyAuthenticator;
    }

    protected ResponseCreator getResponseCreator() {
        return this.responseCreator;
    }

    protected Authenticator getAuthenticator() {
        return this.authenticator;
    }

    protected boolean isPreemptiveAuthentication() {
        return this.preemptiveAuthentication;
    }

    protected void setPreemptiveAuthentication(boolean preemptiveAuthentication) {
        this.preemptiveAuthentication = preemptiveAuthentication;
    }
}

