/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.auth;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.codehaus.httpcache4j.HTTPHost;
import org.codehaus.httpcache4j.HTTPRequest;
import org.codehaus.httpcache4j.HTTPResponse;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.Status;
import org.codehaus.httpcache4j.auth.AuthScheme;
import org.codehaus.httpcache4j.auth.Authenticator;
import org.codehaus.httpcache4j.auth.AuthenticatorStrategy;
import org.codehaus.httpcache4j.auth.BasicAuthenticatorStrategy;
import org.codehaus.httpcache4j.auth.SchemeRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAuthenticator
implements Authenticator {
    private final List<AuthenticatorStrategy> strategies = Lists.newArrayList();
    private final SchemeRegistry registry = new SchemeRegistry();

    public DefaultAuthenticator() {
        this.strategies.addAll(this.createStrategies());
    }

    protected List<AuthenticatorStrategy> createStrategies() {
        return Collections.singletonList(new BasicAuthenticatorStrategy());
    }

    @Override
    public final HTTPRequest prepareAuthentication(HTTPRequest request, HTTPResponse response) {
        Header authenticateHeader;
        HTTPHost host = new HTTPHost(request.getRequestURI());
        if (response == null && this.registry.matches(host)) {
            AuthScheme authScheme = this.registry.get(host);
            for (AuthenticatorStrategy strategy : this.strategies) {
                if (!strategy.supports(authScheme)) continue;
                return strategy.prepare(request, authScheme);
            }
        }
        if (response != null && response.getStatus() == Status.UNAUTHORIZED && (authenticateHeader = response.getHeaders().getFirstHeader("WWW-Authenticate")) != null && request.getChallenge() != null) {
            AuthScheme scheme = new AuthScheme(authenticateHeader);
            this.registry.register(host, scheme);
            for (AuthenticatorStrategy strategy : this.strategies) {
                if (!strategy.supports(scheme)) continue;
                return strategy.prepare(request, scheme);
            }
        }
        return request;
    }

    @Override
    public HTTPRequest preparePreemptiveAuthentication(HTTPRequest request) {
        return this.prepareAuthentication(request, null);
    }
}

