/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.auth;

import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.binary.Base64;
import org.codehaus.httpcache4j.Challenge;
import org.codehaus.httpcache4j.HTTPRequest;
import org.codehaus.httpcache4j.UsernamePasswordChallenge;
import org.codehaus.httpcache4j.auth.AuthScheme;
import org.codehaus.httpcache4j.auth.AuthenticatorStrategy;

public class BasicAuthenticatorStrategy
implements AuthenticatorStrategy {
    public boolean supports(AuthScheme scheme) {
        return "basic".equalsIgnoreCase(scheme.getType());
    }

    public HTTPRequest prepare(HTTPRequest request, AuthScheme scheme) {
        return this.prepare(request, request.getChallenge(), false);
    }

    public HTTPRequest prepareWithProxy(HTTPRequest request, Challenge challenge, AuthScheme scheme) {
        return this.prepare(request, challenge, true);
    }

    private HTTPRequest prepare(HTTPRequest request, Challenge challenge, boolean proxy) {
        HTTPRequest req = request;
        if (challenge instanceof UsernamePasswordChallenge) {
            UsernamePasswordChallenge upc = (UsernamePasswordChallenge)challenge;
            String basicString = upc.getIdentifier() + ":" + new String(upc.getPassword());
            try {
                basicString = new String(Base64.encodeBase64((byte[])basicString.getBytes("UTF-8")));
                String authValue = "Basic " + basicString;
                req = proxy ? request.addHeader("Proxy-Authorization", authValue) : request.addHeader("Authorization", authValue);
            }
            catch (UnsupportedEncodingException e) {
                throw new Error("UTF-8 is not supported on this platform", e);
            }
        }
        return req;
    }
}

