/*
 * Decompiled with CFR 0.152.
 */
package groovy.net.xmlrpc;

import groovy.lang.Closure;
import groovy.lang.GroovyRuntimeException;
import groovy.net.xmlrpc.RPCServer;
import groovy.net.xmlrpc.XMLRPCMessageProcessor;
import java.io.IOException;
import java.util.List;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import uk.co.wilson.net.MinMLJabberPacketServer;
import uk.co.wilson.net.MinMLThreadPool;
import uk.co.wilson.net.xmlrpc.XMLRPCFailException;
import uk.co.wilson.smackx.packet.JabberRPC;

public class JabberRPCServer
extends RPCServer {
    static final String startError = "<methodResponse>\n\t<fault>\n\t\t<value>\n\t\t\t<struct>\n\t\t\t\t<member>\n\t\t\t\t\t<name>faultCode</name>\n\t\t\t\t\t<value><int>";
    static final String middleError = "</int></value>\n\t\t\t\t</member>\n\t\t\t\t<member>\n\t\t\t\t\t<name>faultString</name>\n\t\t\t\t\t<value><string>";
    static final String endError = "</string></value>\n\t\t\t\t</member>\n\t\t\t</struct>\n\t\t</value>\n\t</fault>\n</methodResponse>\n";
    private XMPPConnection connection;
    private MinMLJabberPacketServer server = null;
    private final int minWorkers;
    private final int maxWorkers;
    private final int workerIdleLife;

    public JabberRPCServer(int n, int n2, int n3) {
        this.minWorkers = n;
        this.maxWorkers = n2;
        this.workerIdleLife = n3;
    }

    public JabberRPCServer() {
        this(2, 10, 60000);
    }

    public void startServer(XMPPConnection xMPPConnection) throws IOException {
        this.connection = xMPPConnection;
        this.connection.addConnectionListener(new ConnectionListener(){

            public void connectionClosed() {
                try {
                    JabberRPCServer.this.server.shutDown();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            public void connectionClosedOnError(Exception exception) {
                try {
                    JabberRPCServer.this.server.shutDown();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            public void reconnectingIn(int n) {
            }

            public void reconnectionSuccessful() {
            }

            public void reconnectionFailed(Exception exception) {
                try {
                    JabberRPCServer.this.server.shutDown();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        this.connection.sendPacket((Packet)new Presence(Presence.Type.available, "Jabber.RPC Server", 5, Presence.Mode.available));
        if (this.server != null) {
            this.stopServer();
        }
        this.server = new MinMLJabberPacketServer(xMPPConnection.createPacketCollector(new PacketFilter(){

            public boolean accept(Packet packet) {
                return packet instanceof JabberRPC && ((JabberRPC)packet).getType() == IQ.Type.SET;
            }
        }), this.minWorkers, this.maxWorkers, this.workerIdleLife){

            protected MinMLThreadPool.Worker makeNewWorker() {
                return new MinMLJabberPacketServer.JabberPacketWorker(){

                    protected void process(Object object) throws Exception {
                        JabberRPC jabberRPC = (JabberRPC)((Object)object);
                        StringBuffer stringBuffer = new StringBuffer();
                        try {
                            XMLRPCMessageProcessor xMLRPCMessageProcessor = new XMLRPCMessageProcessor();
                            xMLRPCMessageProcessor.parseMessage(jabberRPC.getChildElementXML());
                            String string = xMLRPCMessageProcessor.getMethodname();
                            List list = xMLRPCMessageProcessor.getParams();
                            Closure closure = (Closure)JabberRPCServer.this.registeredMethods.get(string);
                            Object object2 = null;
                            if (JabberRPCServer.this.preCallMethod != null) {
                                JabberRPCServer.this.preCallMethod.call(new Object[]{string, list.toArray()});
                            }
                            if (closure == null) {
                                if (JabberRPCServer.this.defaultMethod == null) {
                                    throw new GroovyRuntimeException("Method " + string + " is not supported on this server");
                                }
                                object2 = JabberRPCServer.this.defaultMethod.call(new Object[]{string, list.toArray()});
                            } else {
                                object2 = closure.call(list.toArray());
                            }
                            if (object2 == null) {
                                object2 = new Integer(0);
                            }
                            if (JabberRPCServer.this.postCallMethod != null) {
                                JabberRPCServer.this.postCallMethod.call(new Object[]{string, object2});
                            }
                            XMLRPCMessageProcessor.emitResult(stringBuffer, object2);
                            this.sendResponse(jabberRPC, stringBuffer.toString());
                        }
                        catch (Throwable throwable) {
                            int n;
                            String string;
                            Throwable throwable2;
                            if (throwable instanceof InvokerInvocationException) {
                                throwable2 = ((InvokerInvocationException)throwable).getCause();
                            }
                            if (throwable2 instanceof XMLRPCFailException) {
                                string = ((XMLRPCFailException)throwable2).getFaultString();
                                n = ((XMLRPCFailException)throwable2).getFaultCode();
                            } else {
                                string = throwable2.getMessage();
                                n = 0;
                            }
                            if (JabberRPCServer.this.faultMethod != null) {
                                try {
                                    JabberRPCServer.this.faultMethod.call(new Object[]{string, new Integer(n)});
                                }
                                catch (Throwable throwable3) {
                                    // empty catch block
                                }
                            }
                            stringBuffer.setLength(0);
                            stringBuffer.append(JabberRPCServer.startError);
                            stringBuffer.append(String.valueOf(n));
                            stringBuffer.append(JabberRPCServer.middleError);
                            stringBuffer.append(string == null ? throwable2.getClass().getName() : string);
                            stringBuffer.append(JabberRPCServer.endError);
                            this.sendResponse(jabberRPC, stringBuffer.toString());
                        }
                    }

                    private void sendResponse(JabberRPC jabberRPC, String string) {
                        JabberRPC jabberRPC2 = new JabberRPC(string.toString());
                        jabberRPC2.setFrom(jabberRPC.getTo());
                        jabberRPC2.setTo(jabberRPC.getFrom());
                        jabberRPC2.setPacketID(jabberRPC.getPacketID());
                        jabberRPC2.setType(IQ.Type.RESULT);
                        JabberRPCServer.this.connection.sendPacket((Packet)jabberRPC2);
                    }
                };
            }
        };
        Thread thread = new Thread(){

            public void run() {
                JabberRPCServer.this.server.start();
            }
        };
        thread.setDaemon(false);
        thread.setName("Jabber-RPC Server main thread");
        thread.start();
    }

    public void stopServer() throws IOException {
        this.server.shutDown();
    }
}

